/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.BitSetFullException;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.Hamming13;
import io.github.dsheirer.edac.Hamming15;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BPTC_196_96 {
    public static final int BPTC_LENGTH = 196;
    public static final int EXTRACTED_LENGTH = 96;
    public static final int MAX_ORIGINAL_INDEX = 136;
    public static final int COLUMN_COUNT = 15;
    public static final int MESSAGE_COLUMN_COUNT = 12;
    public static final int CHECKSUM_COLUMN_COUNT = 4;
    public static final int MESSAGE_START_INDEX = 4;
    public static int[] BPTC_DEINTERLEAVE = new int[]{0, 181, 166, 151, 136, 121, 106, 91, 76, 61, 46, 31, 16, 1, 182, 167, 152, 137, 122, 107, 92, 77, 62, 47, 32, 17, 2, 183, 168, 153, 138, 123, 108, 93, 78, 63, 48, 33, 18, 3, 184, 169, 154, 139, 124, 109, 94, 79, 64, 49, 34, 19, 4, 185, 170, 155, 140, 125, 110, 95, 80, 65, 50, 35, 20, 5, 186, 171, 156, 141, 126, 111, 96, 81, 66, 51, 36, 21, 6, 187, 172, 157, 142, 127, 112, 97, 82, 67, 52, 37, 22, 7, 188, 173, 158, 143, 128, 113, 98, 83, 68, 53, 38, 23, 8, 189, 174, 159, 144, 129, 114, 99, 84, 69, 54, 39, 24, 9, 190, 175, 160, 145, 130, 115, 100, 85, 70, 55, 40, 25, 10, 191, 176, 161, 146, 131, 116, 101, 86, 71, 56, 41, 26, 11, 192, 177, 162, 147, 132, 117, 102, 87, 72, 57, 42, 27, 12, 193, 178, 163, 148, 133, 118, 103, 88, 73, 58, 43, 28, 13, 194, 179, 164, 149, 134, 119, 104, 89, 74, 59, 44, 29, 14, 195, 180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 15};
    public static int[][] COLUMN_INDEXES = new int[][]{{1, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151, 166, 181}, {2, 17, 32, 47, 62, 77, 92, 107, 122, 137, 152, 167, 182}, {3, 18, 33, 48, 63, 78, 93, 108, 123, 138, 153, 168, 183}, {4, 19, 34, 49, 64, 79, 94, 109, 124, 139, 154, 169, 184}, {5, 20, 35, 50, 65, 80, 95, 110, 125, 140, 155, 170, 185}, {6, 21, 36, 51, 66, 81, 96, 111, 126, 141, 156, 171, 186}, {7, 22, 37, 52, 67, 82, 97, 112, 127, 142, 157, 172, 187}, {8, 23, 38, 53, 68, 83, 98, 113, 128, 143, 158, 173, 188}, {9, 24, 39, 54, 69, 84, 99, 114, 129, 144, 159, 174, 189}, {10, 25, 40, 55, 70, 85, 100, 115, 130, 145, 160, 175, 190}, {11, 26, 41, 56, 71, 86, 101, 116, 131, 146, 161, 176, 191}, {12, 27, 42, 57, 72, 87, 102, 117, 132, 147, 162, 177, 192}, {13, 28, 43, 58, 73, 88, 103, 118, 133, 148, 163, 178, 193}, {14, 29, 44, 59, 74, 89, 104, 119, 134, 149, 164, 179, 194}, {15, 30, 45, 60, 75, 90, 105, 120, 135, 150, 165, 180, 195}};

    public static CorrectedBinaryMessage extract(CorrectedBinaryMessage original) {
        CorrectedBinaryMessage message = BPTC_196_96.deinterleave(original);
        BPTC_196_96.correct(message);
        CorrectedBinaryMessage extracted = new CorrectedBinaryMessage(96);
        extracted.setCorrectedBitCount(message.getCorrectedBitCount());
        int index = 4;
        while (index < 136) {
            if (index % 15 < 12) {
                try {
                    extracted.add(message.get(index));
                }
                catch (BitSetFullException bsfe) {
                    bsfe.printStackTrace();
                    return extracted;
                }
                ++index;
                continue;
            }
            index += 4;
        }
        extracted.set(96, message.get(0));
        extracted.set(97, message.get(1));
        extracted.set(98, message.get(2));
        return extracted;
    }

    private static CorrectedBinaryMessage deinterleave(CorrectedBinaryMessage message) {
        CorrectedBinaryMessage deinterleaved = new CorrectedBinaryMessage(196);
        for (int x = 0; x < BPTC_DEINTERLEAVE.length; ++x) {
            deinterleaved.set(x, message.get(BPTC_DEINTERLEAVE[x]));
        }
        return deinterleaved;
    }

    private static List<Integer> getRowErrors(CorrectedBinaryMessage message) {
        ArrayList<Integer> rowErrors = new ArrayList<Integer>();
        int offset = 0;
        int index = -1;
        for (int row = 0; row < 13; ++row) {
            offset = row * 15 + 1;
            index = Hamming15.getErrorIndex(message, offset);
            if (index < 0) continue;
            rowErrors.add(index);
        }
        return rowErrors;
    }

    private static List<Integer> getColumnErrors(CorrectedBinaryMessage message) {
        ArrayList<Integer> columnErrors = new ArrayList<Integer>();
        int index = -1;
        for (int column = 0; column < 15; ++column) {
            index = Hamming13.getErrorIndex((BinaryMessage)message, COLUMN_INDEXES[column]);
            if (index < 0) continue;
            columnErrors.add(index);
        }
        Collections.sort(columnErrors);
        return columnErrors;
    }

    private static void correct(CorrectedBinaryMessage message) {
        List<Integer> rowErrors = BPTC_196_96.getRowErrors(message);
        if (!rowErrors.isEmpty()) {
            List<Integer> columnErrors = BPTC_196_96.getColumnErrors(message);
            if (BPTC_196_96.matches(rowErrors, columnErrors)) {
                for (Integer n : rowErrors) {
                    message.flip(n);
                }
                message.setCorrectedBitCount(rowErrors.size());
            } else {
                for (Integer n : rowErrors) {
                    message.flip(n);
                }
                List<Integer> columnErrorsPart2 = BPTC_196_96.getColumnErrors(message);
                if (columnErrorsPart2.isEmpty()) {
                    message.setCorrectedBitCount(rowErrors.size());
                } else {
                    for (Integer index : rowErrors) {
                        message.flip(index);
                    }
                    for (Integer index : columnErrors) {
                        message.flip(index);
                    }
                    List<Integer> list = BPTC_196_96.getRowErrors(message);
                    if (list.isEmpty()) {
                        message.setCorrectedBitCount(columnErrors.size());
                    } else {
                        for (Integer index : columnErrors) {
                            message.flip(index);
                        }
                        message.setCorrectedBitCount(16);
                    }
                }
            }
        }
    }

    private static boolean matches(List<Integer> rowErrors, List<Integer> columnErrors) {
        if (rowErrors.size() == columnErrors.size()) {
            for (int x = 0; x < rowErrors.size(); ++x) {
                if (rowErrors.get(x).equals(columnErrors.get(0))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        String raw = "0000000001100010100101100011100100110100110101000100000011101001110001001000100001001010010100001000011111011000000011110000111000111111100011000011100001100000000101001010000100010111010100111001";
        System.out.println("RAW:" + raw);
        CorrectedBinaryMessage message = new CorrectedBinaryMessage(BinaryMessage.load(raw));
        System.out.println("LOD:" + message.toString());
        CorrectedBinaryMessage extracted = BPTC_196_96.extract(message);
        System.out.println("EXT:" + extracted.toString());
    }
}

