/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.window;

import io.github.dsheirer.dsp.window.Window;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorSpecies;

public class VectorWindow
extends Window {
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_PREFERRED;

    public VectorWindow(float[] coefficients) {
        super(coefficients);
    }

    @Override
    public float[] apply(float[] samples) {
        int x;
        this.validate(samples);
        for (x = 0; x < VECTOR_SPECIES.loopBound(this.mCoefficients.length); x += VECTOR_SPECIES.length()) {
            FloatVector.fromArray(VECTOR_SPECIES, (float[])samples, (int)x).mul((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)x)).intoArray(samples, x);
        }
        while (x < this.mCoefficients.length) {
            int n = x;
            samples[n] = samples[n] * this.mCoefficients[x];
            ++x;
        }
        return samples;
    }
}

