/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.symbol;

public enum Dibit {
    D01_PLUS_3(false, true, 1, 4, 1),
    D00_PLUS_1(false, false, 0, 0, 0),
    D10_MINUS_1(true, false, 2, 8, 2),
    D11_MINUS_3(true, true, 3, 12, 3);

    private boolean mBit1;
    private boolean mBit2;
    private int mLowValue;
    private int mHighValue;
    private int mValue;

    private Dibit(boolean bit1, boolean bit2, int lowValue, int highValue, int value) {
        this.mBit1 = bit1;
        this.mBit2 = bit2;
        this.mLowValue = lowValue;
        this.mHighValue = highValue;
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public Dibit getAllowableTransition1() {
        switch (this) {
            case D00_PLUS_1: {
                return D01_PLUS_3;
            }
            case D01_PLUS_3: {
                return D00_PLUS_1;
            }
            case D10_MINUS_1: {
                return D11_MINUS_3;
            }
            case D11_MINUS_3: {
                return D10_MINUS_1;
            }
        }
        return D00_PLUS_1;
    }

    public Dibit getAllowableTransition2() {
        switch (this) {
            case D00_PLUS_1: {
                return D10_MINUS_1;
            }
            case D01_PLUS_3: {
                return D11_MINUS_3;
            }
            case D10_MINUS_1: {
                return D00_PLUS_1;
            }
            case D11_MINUS_3: {
                return D01_PLUS_3;
            }
        }
        return D00_PLUS_1;
    }

    public boolean isAllowableTransition(Dibit dibit) {
        return dibit == this.getAllowableTransition1() || dibit == this.getAllowableTransition2();
    }

    public boolean getBit1() {
        return this.mBit1;
    }

    public boolean getBit2() {
        return this.mBit2;
    }

    public int getLowValue() {
        return this.mLowValue;
    }

    public int getHighValue() {
        return this.mHighValue;
    }

    public static Dibit inverted(Dibit symbol) {
        switch (symbol) {
            case D10_MINUS_1: {
                return D11_MINUS_3;
            }
            case D11_MINUS_3: {
                return D01_PLUS_3;
            }
            case D00_PLUS_1: {
                return D10_MINUS_1;
            }
        }
        return D00_PLUS_1;
    }

    public static Dibit parse(byte value, int index) {
        switch (value >> (3 - index) * 2 & 3) {
            case 0: {
                return D00_PLUS_1;
            }
            case 1: {
                return D01_PLUS_3;
            }
            case 2: {
                return D10_MINUS_1;
            }
            case 3: {
                return D11_MINUS_3;
            }
        }
        return D00_PLUS_1;
    }

    public Dibit rotate(Rotation rotation) {
        switch (this) {
            case D00_PLUS_1: {
                switch (rotation) {
                    case PLUS90: {
                        return D01_PLUS_3;
                    }
                    case MINUS90: {
                        return D10_MINUS_1;
                    }
                    case INVERT: {
                        return D11_MINUS_3;
                    }
                }
                break;
            }
            case D01_PLUS_3: {
                switch (rotation) {
                    case PLUS90: {
                        return D11_MINUS_3;
                    }
                    case MINUS90: {
                        return D00_PLUS_1;
                    }
                    case INVERT: {
                        return D10_MINUS_1;
                    }
                }
                break;
            }
            case D10_MINUS_1: {
                switch (rotation) {
                    case PLUS90: {
                        return D00_PLUS_1;
                    }
                    case MINUS90: {
                        return D11_MINUS_3;
                    }
                    case INVERT: {
                        return D01_PLUS_3;
                    }
                }
                break;
            }
            case D11_MINUS_3: {
                switch (rotation) {
                    case PLUS90: {
                        return D10_MINUS_1;
                    }
                    case MINUS90: {
                        return D01_PLUS_3;
                    }
                    case INVERT: {
                        return D00_PLUS_1;
                    }
                }
            }
        }
        return D00_PLUS_1;
    }

    public static Dibit fromValue(int value) {
        switch (value) {
            default: {
                return D00_PLUS_1;
            }
            case 1: {
                return D01_PLUS_3;
            }
            case 2: {
                return D10_MINUS_1;
            }
            case 3: 
        }
        return D11_MINUS_3;
    }

    public static void main(String[] args) {
        byte a = 27;
        Dibit d1 = Dibit.parse(a, 0);
        Dibit d2 = Dibit.parse(a, 1);
        Dibit d3 = Dibit.parse(a, 2);
        Dibit d4 = Dibit.parse(a, 3);
        System.out.println("1: " + String.valueOf((Object)d1) + " 2:" + String.valueOf((Object)d2) + " 3:" + String.valueOf((Object)d3) + " 4:" + String.valueOf((Object)d4));
    }

    public static enum Rotation {
        PLUS90,
        MINUS90,
        INVERT;

    }
}

