/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.psk.pll;

import java.util.Map;
import java.util.TreeMap;

public enum PLLBandwidth {
    BW_400(400.0, 0, 1),
    BW_300(300.0, 2, 3),
    BW_250(250.0, 4, 5),
    BW_200(200.0, 6, 7);

    private double mLoopBandwidth;
    private int mRangeStart;
    private int mRangeEnd;
    private static Map<Integer, PLLBandwidth> LOOKUP_MAP;

    private PLLBandwidth(double loopBandwidth, int start, int end) {
        this.mLoopBandwidth = loopBandwidth;
        this.mRangeStart = start;
        this.mRangeEnd = end;
    }

    public double getLoopBandwidth() {
        return this.mLoopBandwidth;
    }

    public int getRangeStart() {
        return this.mRangeStart;
    }

    public int getRangeEnd() {
        return this.mRangeEnd;
    }

    public static PLLBandwidth fromSyncCount(int syncCount) {
        PLLBandwidth mapValue = LOOKUP_MAP.get(syncCount);
        if (mapValue != null) {
            return mapValue;
        }
        return BW_200;
    }

    static {
        LOOKUP_MAP = new TreeMap<Integer, PLLBandwidth>();
        for (PLLBandwidth pllBandwidth : PLLBandwidth.values()) {
            for (int x = pllBandwidth.getRangeStart(); x <= pllBandwidth.getRangeEnd(); ++x) {
                LOOKUP_MAP.put(x, pllBandwidth);
            }
        }
    }
}

