/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.psk;

import io.github.dsheirer.buffer.ComplexCircularBuffer;
import io.github.dsheirer.sample.complex.Complex;

public class SymbolDecisionData {
    public static final Complex DIFFERENTIAL_OFFSET = Complex.fromAngle(0.7853981633974483);
    private ComplexCircularBuffer mBuffer;
    private float mSamplingPoint;
    private float mSamplesPerSymbol;

    public SymbolDecisionData(float samplesPerSymbol) {
        this.mSamplesPerSymbol = samplesPerSymbol;
        this.mBuffer = new ComplexCircularBuffer(8);
    }

    public void receive(float inphase, float quadrature) {
        this.mBuffer.put(new Complex(inphase, quadrature));
    }

    public void receive(Complex complex) {
        this.mBuffer.put(complex.copy());
    }

    public void setSamplingPoint(float samplingPoint) {
        this.mSamplingPoint = samplingPoint;
    }

    public float getSamplingPoint() {
        return this.mSamplingPoint;
    }

    public Complex[] getSamples() {
        return this.mBuffer.getAll();
    }

    public Complex[] getSamples(int length) {
        return this.mBuffer.get(length);
    }

    public Complex[] getDemodulated() {
        Complex[] samples = this.mBuffer.getAll();
        int length = samples.length / 2;
        Complex[] demodulated = new Complex[length];
        for (int x = 0; x < samples.length / 2; ++x) {
            Complex copy = samples[length + x].copy();
            copy.multiply(samples[x].conjugate());
            demodulated[x] = copy;
        }
        return demodulated;
    }
}

