/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.psk;

import io.github.dsheirer.dsp.psk.DQPSKDecisionDirectedSymbolEvaluator;
import io.github.dsheirer.dsp.psk.InterpolatingSampleBuffer;
import io.github.dsheirer.dsp.psk.PSKDemodulator;
import io.github.dsheirer.dsp.psk.pll.IPhaseLockedLoop;
import io.github.dsheirer.dsp.symbol.Dibit;
import io.github.dsheirer.sample.complex.Complex;

public class DQPSKDecisionDirectedDemodulator
extends PSKDemodulator<Dibit> {
    protected DQPSKDecisionDirectedSymbolEvaluator mSymbolEvaluator = new DQPSKDecisionDirectedSymbolEvaluator();
    private Complex mPreviousPrecedingSample = new Complex(0.0f, 0.0f);
    private Complex mPreviousCurrentSample = new Complex(0.0f, 0.0f);
    private Complex mPrecedingSample = new Complex(0.0f, 0.0f);
    private Complex mCurrentSample = new Complex(0.0f, 0.0f);
    private Complex mPrecedingSymbol = new Complex(0.0f, 0.0f);
    protected Complex mCurrentSymbol = new Complex(0.0f, 0.0f);

    public DQPSKDecisionDirectedDemodulator(IPhaseLockedLoop phaseLockedLoop, InterpolatingSampleBuffer interpolatingSampleBuffer) {
        super(interpolatingSampleBuffer, phaseLockedLoop);
    }

    @Override
    protected void calculateSymbol() {
        this.mPrecedingSample = this.getInterpolatingSampleBuffer().getPrecedingSample();
        this.mCurrentSample = this.getInterpolatingSampleBuffer().getCurrentSample();
        this.mPrecedingSymbol.setInphase(Complex.multiplyInphase(this.mPrecedingSample.inphase(), this.mPrecedingSample.quadrature(), this.mPreviousPrecedingSample.inphase(), -this.mPreviousPrecedingSample.quadrature()));
        this.mPrecedingSymbol.setQuadrature(Complex.multiplyQuadrature(this.mPrecedingSample.inphase(), this.mPrecedingSample.quadrature(), this.mPreviousPrecedingSample.inphase(), -this.mPreviousPrecedingSample.quadrature()));
        this.mCurrentSymbol.setInphase(Complex.multiplyInphase(this.mCurrentSample.inphase(), this.mCurrentSample.quadrature(), this.mPreviousCurrentSample.inphase(), -this.mPreviousCurrentSample.quadrature()));
        this.mCurrentSymbol.setQuadrature(Complex.multiplyQuadrature(this.mCurrentSample.inphase(), this.mCurrentSample.quadrature(), this.mPreviousCurrentSample.inphase(), -this.mPreviousCurrentSample.quadrature()));
        this.mPrecedingSymbol.normalize();
        this.mCurrentSymbol.normalize();
        this.mSymbolEvaluator.setSymbol(this.mPrecedingSymbol, this.mCurrentSymbol);
        this.getInterpolatingSampleBuffer().resetAndAdjust(this.mSymbolEvaluator.getTimingError());
        this.getPLL().adjust(DQPSKDecisionDirectedDemodulator.clip(this.mSymbolEvaluator.getPhaseError(), 0.5f));
        this.mPreviousPrecedingSample.setValues(this.mPrecedingSample);
        this.mPreviousCurrentSample.setValues(this.mCurrentSample);
        this.broadcast(this.mSymbolEvaluator.getSymbolDecision());
    }
}

