/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.oscillator;

import io.github.dsheirer.dsp.oscillator.AbstractOscillator;
import io.github.dsheirer.dsp.oscillator.IComplexOscillator;
import io.github.dsheirer.sample.complex.ComplexSamples;
import org.apache.commons.math3.util.FastMath;

public class ScalarComplexOscillator
extends AbstractOscillator
implements IComplexOscillator {
    private float mCosineAngle;
    private float mSineAngle;
    private float mPreviousInphase = 1.0f;
    private float mPreviousQuadrature = 0.0f;

    public ScalarComplexOscillator(double frequency, double sampleRate) {
        super(frequency, sampleRate);
    }

    @Override
    protected void update() {
        super.update();
        float angle = this.getAnglePerSample();
        this.mCosineAngle = (float)FastMath.cos((double)this.getAnglePerSample());
        this.mSineAngle = (float)FastMath.sin((double)this.getAnglePerSample());
    }

    @Override
    public float[] generate(int sampleCount) {
        float[] samples = new float[sampleCount * 2];
        float cosineAngle = (float)FastMath.cos((double)this.getAnglePerSample());
        float sineAngle = (float)FastMath.sin((double)this.getAnglePerSample());
        float previousInphase = this.mPreviousInphase;
        float previousQuadrature = this.mPreviousQuadrature;
        int gainPointer = 0;
        for (int samplePointer = 0; samplePointer < samples.length; samplePointer += 2) {
            if (++gainPointer % 10 == 0) {
                gainPointer = 0;
                float gain = (3.0f - (previousInphase * previousInphase + previousQuadrature * previousQuadrature)) / 2.0f;
                samples[samplePointer] = (previousInphase * cosineAngle - previousQuadrature * sineAngle) * gain;
                samples[samplePointer + 1] = (previousInphase * sineAngle + previousQuadrature * cosineAngle) * gain;
            } else {
                samples[samplePointer] = previousInphase * cosineAngle - previousQuadrature * sineAngle;
                samples[samplePointer + 1] = previousInphase * sineAngle + previousQuadrature * cosineAngle;
            }
            previousInphase = samples[samplePointer];
            previousQuadrature = samples[samplePointer + 1];
        }
        this.mPreviousInphase = previousInphase;
        this.mPreviousQuadrature = previousQuadrature;
        return samples;
    }

    @Override
    public ComplexSamples generateComplexSamples(int sampleCount, long timestamp) {
        float[] iSamples = new float[sampleCount];
        float[] qSamples = new float[sampleCount];
        float cosineAngle = (float)FastMath.cos((double)this.getAnglePerSample());
        float sineAngle = (float)FastMath.sin((double)this.getAnglePerSample());
        float previousInphase = this.mPreviousInphase;
        float previousQuadrature = this.mPreviousQuadrature;
        int gainPointer = 0;
        for (int samplePointer = 0; samplePointer < iSamples.length; ++samplePointer) {
            if (++gainPointer % 100 == 0) {
                gainPointer = 0;
                float gain = (3.0f - (previousInphase * previousInphase + previousQuadrature * previousQuadrature)) / 2.0f;
                iSamples[samplePointer] = (previousInphase * cosineAngle - previousQuadrature * sineAngle) * gain;
                qSamples[samplePointer] = (previousInphase * sineAngle + previousQuadrature * cosineAngle) * gain;
            } else {
                iSamples[samplePointer] = previousInphase * cosineAngle - previousQuadrature * sineAngle;
                qSamples[samplePointer] = previousInphase * sineAngle + previousQuadrature * cosineAngle;
            }
            previousInphase = iSamples[samplePointer];
            previousQuadrature = qSamples[samplePointer];
        }
        this.mPreviousInphase = previousInphase;
        this.mPreviousQuadrature = previousQuadrature;
        return new ComplexSamples(iSamples, qSamples, timestamp);
    }
}

