/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.mixer;

import io.github.dsheirer.dsp.mixer.ComplexMixer;
import io.github.dsheirer.dsp.mixer.ScalarComplexMixer;
import io.github.dsheirer.dsp.mixer.VectorComplexMixer;
import io.github.dsheirer.vector.calibrate.CalibrationManager;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexMixerFactory {
    private static final Logger mLog = LoggerFactory.getLogger(ComplexMixerFactory.class);

    public static ComplexMixer getMixer(double frequency, double sampleRate) {
        Implementation implementation = CalibrationManager.getInstance().getImplementation(CalibrationType.MIXER_COMPLEX);
        switch (implementation) {
            case VECTOR_SIMD_PREFERRED: {
                return new VectorComplexMixer(frequency, sampleRate);
            }
            case SCALAR: {
                return new ScalarComplexMixer(frequency, sampleRate);
            }
        }
        mLog.warn("Unrecognized complex mixer implementation: " + String.valueOf((Object)implementation));
        return new ScalarComplexMixer(frequency, sampleRate);
    }
}

