/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.mixer;

import io.github.dsheirer.dsp.oscillator.IComplexOscillator;
import io.github.dsheirer.dsp.oscillator.OscillatorFactory;
import io.github.dsheirer.dsp.oscillator.ScalarComplexOscillator;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.sample.complex.InterleavedComplexSamples;

public abstract class ComplexMixer {
    private IComplexOscillator mOscillator;

    public ComplexMixer(double frequency, double sampleRate, boolean disableSIMD) {
        this.mOscillator = disableSIMD ? new ScalarComplexOscillator(frequency, sampleRate) : OscillatorFactory.getComplexOscillator(frequency, sampleRate);
    }

    public ComplexMixer(double frequency, double sampleRate) {
        this.mOscillator = OscillatorFactory.getComplexOscillator(frequency, sampleRate);
    }

    public void setFrequency(double frequency) {
        this.mOscillator.setFrequency(frequency);
    }

    public boolean hasFrequency() {
        return this.mOscillator.hasFrequency();
    }

    public double getFrequency() {
        return this.mOscillator.getFrequency();
    }

    public void setSampleRate(double sampleRate) {
        this.mOscillator.setSampleRate(sampleRate);
    }

    protected ComplexSamples generate(int sampleCount, long timestamp) {
        return this.mOscillator.generateComplexSamples(sampleCount, timestamp);
    }

    public ComplexSamples mix(ComplexSamples samples) {
        return this.mix(samples.i(), samples.q(), samples.timestamp());
    }

    public ComplexSamples mix(InterleavedComplexSamples samples) {
        return this.mix(samples.toDeinterleaved());
    }

    public abstract ComplexSamples mix(float[] var1, float[] var2, long var3);
}

