/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.magnitude;

import io.github.dsheirer.dsp.magnitude.IMagnitudeCalculator;
import io.github.dsheirer.dsp.magnitude.ScalarMagnitudeCalculator;
import io.github.dsheirer.dsp.magnitude.VectorMagnitudeCalculator128;
import io.github.dsheirer.dsp.magnitude.VectorMagnitudeCalculator256;
import io.github.dsheirer.dsp.magnitude.VectorMagnitudeCalculator512;
import io.github.dsheirer.dsp.magnitude.VectorMagnitudeCalculator64;
import io.github.dsheirer.vector.calibrate.CalibrationManager;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MagnitudeFactory {
    private static final Logger mLog = LoggerFactory.getLogger(MagnitudeFactory.class);

    public static IMagnitudeCalculator getMagnitudeCalculator() {
        Implementation implementation = CalibrationManager.getInstance().getImplementation(CalibrationType.MAGNITUDE);
        switch (implementation) {
            case VECTOR_SIMD_64: {
                return new VectorMagnitudeCalculator64();
            }
            case VECTOR_SIMD_128: {
                return new VectorMagnitudeCalculator128();
            }
            case VECTOR_SIMD_256: {
                return new VectorMagnitudeCalculator256();
            }
            case VECTOR_SIMD_512: {
                return new VectorMagnitudeCalculator512();
            }
        }
        return new ScalarMagnitudeCalculator();
    }
}

