/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.gain.complex;

import io.github.dsheirer.dsp.gain.complex.ComplexGain;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.vector.VectorUtilities;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.VectorSpecies;

public class VectorComplexGain
extends ComplexGain {
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_PREFERRED;

    public VectorComplexGain(float gain) {
        super(gain);
    }

    @Override
    public ComplexSamples apply(float[] i, float[] q, long timestamp) {
        VectorUtilities.checkComplexArrayLength(i, q, VECTOR_SPECIES);
        for (int x = 0; x < i.length; x += VECTOR_SPECIES.length()) {
            FloatVector.fromArray(VECTOR_SPECIES, (float[])i, (int)x).mul(this.mGain).intoArray(i, x);
            FloatVector.fromArray(VECTOR_SPECIES, (float[])q, (int)x).mul(this.mGain).intoArray(q, x);
        }
        return new ComplexSamples(i, q, timestamp);
    }
}

