/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.gain;

public class NonClippingGain {
    private float mGain;
    private float mMaxValue;

    public NonClippingGain(float gain, float maxValue) {
        this.mGain = gain;
        this.mMaxValue = maxValue;
    }

    public float apply(float sample) {
        float adjusted = sample * this.mGain;
        if (adjusted > this.mMaxValue) {
            adjusted = this.mMaxValue;
        }
        if (adjusted < -this.mMaxValue) {
            adjusted = -this.mMaxValue;
        }
        return adjusted;
    }

    public float[] apply(float[] samples) {
        for (int x = 0; x < samples.length; ++x) {
            samples[x] = this.apply(samples[x]);
        }
        return samples;
    }
}

