/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.gain;

import io.github.dsheirer.dsp.gain.GainController;
import io.github.dsheirer.sample.real.RealSampleListener;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectGainControl
implements GainController,
RealSampleListener {
    private static final Logger mLog = LoggerFactory.getLogger(DirectGainControl.class);
    private float mDefaultGain;
    private float mGain;
    private float mMinimum;
    private float mMaximum;
    private float mIncrement;
    private RealSampleListener mListener;

    public DirectGainControl(float gain, float minimum, float maximum, float increment) {
        Validate.isTrue((minimum > 0.0f ? 1 : 0) != 0);
        this.mDefaultGain = gain;
        this.mGain = gain;
        this.mMinimum = minimum;
        this.mMaximum = maximum;
        this.mIncrement = increment;
    }

    public void dispose() {
        this.mListener = null;
    }

    public float correct(float sample) {
        return sample * this.mGain;
    }

    @Override
    public void receive(float sample) {
        this.mListener.receive(this.correct(sample));
    }

    @Override
    public void reset() {
        this.mGain = this.mDefaultGain;
    }

    @Override
    public void increase() {
        this.mGain += this.mIncrement;
        if (this.mGain > this.mMaximum) {
            this.mGain = this.mMaximum;
        }
    }

    @Override
    public void decrease() {
        this.mGain -= this.mIncrement;
        if (this.mGain < this.mMinimum) {
            this.mGain = this.mMinimum;
        }
    }

    public void setListener(RealSampleListener listener) {
        this.mListener = listener;
    }
}

