/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.gain;

import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioGainAndDcFilter {
    private static final Logger mLog = LoggerFactory.getLogger(AudioGainAndDcFilter.class);
    private static final float MAX_AMPLITUDE = 0.95f;
    private static final float GAIN_LOOP_BANDWIDTH = 0.0015f;
    private float mMinGain;
    private float mMaxGain;
    private float mCurrentGain;
    private float mObjectiveGain;
    private float mObjectiveAmplitude;
    private float mMaxObservedAmplitude;

    public AudioGainAndDcFilter(float minGain, float maxGain, float objectiveAmplitude) {
        this.mMinGain = minGain;
        this.mMaxGain = maxGain;
        this.mObjectiveAmplitude = objectiveAmplitude;
        this.reset();
    }

    public void reset() {
        this.mMaxObservedAmplitude = 0.0f;
        this.mObjectiveGain = 1.0f;
        this.mCurrentGain = 1.0f;
    }

    public float[] process(float[] samples) {
        float dcAccumulator = 0.0f;
        this.mMaxObservedAmplitude *= 0.9f;
        for (float sample : samples) {
            dcAccumulator += sample;
            float currentAmplitude = FastMath.min((float)Math.abs(sample), (float)2.0f);
            if (!(currentAmplitude > this.mMaxObservedAmplitude)) continue;
            this.mMaxObservedAmplitude = currentAmplitude;
        }
        this.mObjectiveGain = this.mObjectiveAmplitude / this.mMaxObservedAmplitude;
        if (this.mObjectiveGain > this.mMaxGain) {
            this.mObjectiveGain = this.mMaxGain;
        } else if (this.mObjectiveGain < this.mMinGain) {
            this.mObjectiveGain = this.mMinGain;
        }
        float dcOffset = dcAccumulator / (float)samples.length;
        float gain = this.mCurrentGain;
        float objective = this.mObjectiveGain;
        float[] processed = new float[samples.length];
        boolean objectiveAchieved = gain == objective;
        for (int x = 0; x < samples.length; ++x) {
            if (!objectiveAchieved && Math.abs(objective - (gain += (objective - gain) * 0.0015f)) < 5.0E-5f) {
                gain = objective;
                objectiveAchieved = true;
            }
            float amplified = (samples[x] - dcOffset) * gain;
            amplified = FastMath.min((float)amplified, (float)0.95f);
            processed[x] = amplified = FastMath.max((float)amplified, (float)-0.95f);
        }
        this.mCurrentGain = gain;
        this.mObjectiveGain = objective;
        return processed;
    }
}

