/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.fsk;

import io.github.dsheirer.dsp.fsk.ISyncStateListener;
import io.github.dsheirer.dsp.fsk.SyncState;
import io.github.dsheirer.dsp.symbol.ISyncDetectListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizationMonitor
implements ISyncDetectListener {
    private static final Logger mLog = LoggerFactory.getLogger(SynchronizationMonitor.class);
    private ISyncStateListener mSyncStateListener;
    private SyncState mSyncState = SyncState.COARSE;
    private int mSyncCount;
    private int mSymbolCount = 0;
    private int mMessageLength;

    public SynchronizationMonitor(int messageLength) {
        this.mMessageLength = messageLength;
    }

    public void reset() {
        this.setSyncState(SyncState.COARSE);
        this.mSymbolCount = 0;
    }

    private void setSyncState(SyncState syncState) {
        if (this.mSyncState != syncState) {
            this.mSyncState = syncState;
            if (this.mSyncStateListener != null) {
                this.mSyncStateListener.setSyncState(this.mSyncState);
            }
        }
    }

    private void updateSyncState() {
        if (this.mSyncCount < 0) {
            this.mSyncCount = 0;
            return;
        }
        switch (this.mSyncCount) {
            case 0: {
                this.setSyncState(SyncState.COARSE);
                break;
            }
            case 1: {
                this.setSyncState(SyncState.MEDIUM);
                break;
            }
            default: {
                this.setSyncState(SyncState.FINE);
            }
        }
        if (this.mSyncCount > 3) {
            this.mSyncCount = 3;
        }
    }

    @Override
    public void syncDetected(int bitErrors) {
        this.mSymbolCount = 0;
        ++this.mSyncCount;
        this.updateSyncState();
    }

    @Override
    public void syncLost(int bitsProcessed) {
    }

    public void increment() {
        ++this.mSymbolCount;
        if (this.mSymbolCount > this.mMessageLength) {
            this.mSymbolCount = 0;
            --this.mSyncCount;
            this.updateSyncState();
        }
    }

    public void setListener(ISyncStateListener listener) {
        this.mSyncStateListener = listener;
    }
}

