/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.fm;

import io.github.dsheirer.dsp.fm.IDemodulator;
import org.apache.commons.math3.util.FastMath;

public class ScalarFMDemodulator
implements IDemodulator {
    protected float mPreviousI = 0.0f;
    protected float mPreviousQ = 0.0f;
    protected float mGain;

    public ScalarFMDemodulator() {
        this(1.0f);
    }

    public ScalarFMDemodulator(float gain) {
        this.mGain = gain;
    }

    @Override
    public float[] demodulate(float[] i, float[] q) {
        float[] demodulated = new float[i.length];
        float demodI = i[0] * this.mPreviousI - q[0] * -this.mPreviousQ;
        float demodQ = q[0] * this.mPreviousI + i[0] * -this.mPreviousQ;
        demodulated[0] = demodI != 0.0f ? (float)FastMath.atan((double)(demodQ / demodI)) : (float)FastMath.atan((double)(demodQ / Float.MIN_VALUE));
        this.mPreviousI = i[i.length - 1];
        this.mPreviousQ = q[q.length - 1];
        for (int x = 1; x < i.length; ++x) {
            demodI = i[x] * i[x - 1] - q[x] * -q[x - 1];
            demodQ = q[x] * i[x - 1] + i[x] * -q[x - 1];
            demodulated[x] = demodI != 0.0f ? (float)FastMath.atan((double)(demodQ / demodI)) : (float)FastMath.atan((double)(demodQ / Float.MIN_VALUE));
        }
        return demodulated;
    }

    public void dispose() {
    }

    public void reset() {
        this.mPreviousI = 0.0f;
        this.mPreviousQ = 0.0f;
    }

    public void setGain(float gain) {
        this.mGain = gain;
    }
}

