/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.fm;

import io.github.dsheirer.dsp.fm.IDemodulator;
import io.github.dsheirer.dsp.fm.ScalarFMDemodulator;
import io.github.dsheirer.dsp.fm.VectorFMDemodulator128;
import io.github.dsheirer.dsp.fm.VectorFMDemodulator256;
import io.github.dsheirer.dsp.fm.VectorFMDemodulator512;
import io.github.dsheirer.dsp.fm.VectorFMDemodulator64;
import io.github.dsheirer.vector.calibrate.CalibrationManager;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FmDemodulatorFactory {
    private static final Logger mLog = LoggerFactory.getLogger(FmDemodulatorFactory.class);

    public static IDemodulator getFmDemodulator() {
        Implementation implementation = CalibrationManager.getInstance().getImplementation(CalibrationType.FM_DEMODULATOR);
        switch (implementation) {
            case VECTOR_SIMD_64: {
                return new VectorFMDemodulator64();
            }
            case VECTOR_SIMD_128: {
                return new VectorFMDemodulator128();
            }
            case VECTOR_SIMD_256: {
                return new VectorFMDemodulator256();
            }
            case VECTOR_SIMD_512: {
                return new VectorFMDemodulator512();
            }
        }
        return new ScalarFMDemodulator();
    }
}

