/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.iir;

public class SinglePoleIirFilter {
    private float mAlpha;
    private float mOneMinusAlpha;
    private float mOutput;

    public SinglePoleIirFilter(float alpha) {
        if ((double)alpha < 0.0 || (double)alpha > 1.0) {
            throw new IllegalArgumentException("alpha decay value must be in range: 0.0 - 1.0");
        }
        this.mAlpha = alpha;
        this.mOneMinusAlpha = 1.0f - alpha;
    }

    public float filter(float sample) {
        this.mOutput = this.mOutput * this.mOneMinusAlpha + this.mAlpha * sample;
        return this.mOutput;
    }

    public float getValue() {
        return this.mOutput;
    }
}

