/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.iir;

import org.apache.commons.math3.util.FastMath;

public class DeemphasisFilter {
    private static final float MAX_SAMPLE_VALUE = 0.95f;
    private float mAlpha;
    private float mGain;
    private float mPrevious = 0.0f;

    public DeemphasisFilter(float sampleRate, float cutoff, float gain) {
        this.mAlpha = (float)FastMath.exp((double)(Math.PI * -2 * (double)cutoff * (1.0 / (double)sampleRate)));
        this.mGain = gain;
    }

    public float filter(float sample) {
        this.mPrevious = sample + this.mAlpha * this.mPrevious;
        return this.declip(this.mPrevious * this.mGain);
    }

    private float declip(float value) {
        if (value > 0.95f) {
            return 0.95f;
        }
        return FastMath.max((float)value, (float)-0.95f);
    }

    public float[] filter(float[] samples) {
        for (int x = 0; x < samples.length; ++x) {
            samples[x] = this.filter(samples[x]);
        }
        return samples;
    }
}

