/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.hilbert;

import io.github.dsheirer.dsp.filter.hilbert.HilbertTransform;
import io.github.dsheirer.dsp.filter.hilbert.VectorHilbertTransform128Bits;
import io.github.dsheirer.dsp.filter.hilbert.VectorHilbertTransform256Bits;
import io.github.dsheirer.dsp.filter.hilbert.VectorHilbertTransform512Bits;
import io.github.dsheirer.dsp.filter.hilbert.VectorHilbertTransform64Bits;
import io.github.dsheirer.dsp.filter.hilbert.VectorHilbertTransformDefaultBits;
import io.github.dsheirer.dsp.oscillator.IRealOscillator;
import io.github.dsheirer.dsp.oscillator.OscillatorFactory;
import io.github.dsheirer.sample.SampleUtils;
import io.github.dsheirer.sample.complex.ComplexSamples;
import java.util.Arrays;

public class ScalarHilbertTransform
extends HilbertTransform {
    @Override
    public ComplexSamples filter(float[] realSamples, long timestamp) {
        int bufferLength = realSamples.length / 2;
        if (this.mIBuffer.length != bufferLength + this.mIOverlap) {
            float[] iTemp = new float[bufferLength + this.mIOverlap];
            float[] qTemp = new float[bufferLength + this.mQOverlap];
            System.arraycopy(this.mIBuffer, 0, iTemp, 0, this.mIOverlap);
            System.arraycopy(this.mQBuffer, 0, qTemp, 0, this.mQOverlap);
            this.mIBuffer = iTemp;
            this.mQBuffer = qTemp;
        }
        ComplexSamples deinterleaved = SampleUtils.deinterleave(realSamples, timestamp);
        System.arraycopy(deinterleaved.i(), 0, this.mIBuffer, this.mIOverlap, deinterleaved.i().length);
        System.arraycopy(deinterleaved.q(), 0, this.mQBuffer, this.mQOverlap, deinterleaved.q().length);
        float[] i = new float[bufferLength];
        float[] q = new float[bufferLength];
        for (int x = 0; x < bufferLength; ++x) {
            float accumulator = 0.0f;
            for (int y = 0; y < this.mCoefficients.length; ++y) {
                accumulator += this.mCoefficients[y] * this.mQBuffer[x + y];
            }
            i[x] = this.mIBuffer[x];
            q[x] = accumulator;
        }
        System.arraycopy(this.mIBuffer, this.mIBuffer.length - this.mIOverlap, this.mIBuffer, 0, this.mIOverlap);
        System.arraycopy(this.mQBuffer, this.mQBuffer.length - this.mQOverlap, this.mQBuffer, 0, this.mQOverlap);
        return new ComplexSamples(i, q, timestamp);
    }

    public static void main(String[] args) {
        int iterations = 1000000;
        int bufferSize = 2048;
        IRealOscillator realOscillator = OscillatorFactory.getRealOscillator(2.0, 40.0);
        float[] realSamples = realOscillator.generate(bufferSize);
        ScalarHilbertTransform hilbertTransform = new ScalarHilbertTransform();
        VectorHilbertTransformDefaultBits vectorDefault = new VectorHilbertTransformDefaultBits();
        VectorHilbertTransform512Bits vector512 = new VectorHilbertTransform512Bits();
        VectorHilbertTransform256Bits vector256 = new VectorHilbertTransform256Bits();
        VectorHilbertTransform128Bits vector128 = new VectorHilbertTransform128Bits();
        VectorHilbertTransform64Bits vector64 = new VectorHilbertTransform64Bits();
        System.out.println("Starting ...");
        float accumulator = 0.0f;
        long start = System.currentTimeMillis();
        boolean validate = true;
        if (validate) {
            ComplexSamples scalar = hilbertTransform.filter(realSamples, 0L);
            ComplexSamples vector = vector512.filter(realSamples, start);
            System.out.println("SI: " + Arrays.toString(scalar.i()));
            System.out.println("VI: " + Arrays.toString(vector.i()));
            System.out.println("SQ: " + Arrays.toString(scalar.q()));
            System.out.println("VQ: " + Arrays.toString(vector.q()));
        } else {
            for (int count = 0; count < iterations; ++count) {
                ComplexSamples filtered = vector512.filter(realSamples, start);
                accumulator += filtered.q()[2];
            }
            System.out.println("Accumulator: " + accumulator);
            System.out.println("Elapsed: " + (float)(System.currentTimeMillis() - start) / 1000.0f + " seconds");
        }
        System.out.println("Finished!");
    }
}

