/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.halfband;

import io.github.dsheirer.dsp.filter.decimate.IRealDecimationFilter;
import io.github.dsheirer.vector.VectorUtilities;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

public class VectorRealHalfBandDecimationFilter63Tap512Bit
implements IRealDecimationFilter {
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_512;
    private static final int COEFFICIENTS_LENGTH = 63;
    private float[] mCoefficients = new float[64];
    private float[] mBuffer;
    private int mBufferOverlap;

    public VectorRealHalfBandDecimationFilter63Tap512Bit(float[] coefficients) {
        if (coefficients.length != 63) {
            throw new IllegalArgumentException("Half-band filter coefficients must be 63 taps.  You supplied a filter with " + coefficients.length + " taps.");
        }
        VectorUtilities.checkSpecies(VECTOR_SPECIES);
        System.arraycopy(coefficients, 0, this.mCoefficients, 0, coefficients.length);
        this.mBufferOverlap = Math.max(VECTOR_SPECIES.length() - 1, coefficients.length - 1);
    }

    @Override
    public float[] decimateReal(float[] samples) {
        if (samples.length % 2 != 0) {
            throw new IllegalArgumentException("Samples array length must be an integer multiple of 2");
        }
        int bufferLength = samples.length + this.mBufferOverlap;
        if (this.mBuffer == null) {
            this.mBuffer = new float[bufferLength];
        } else if (this.mBuffer.length != bufferLength) {
            float[] temp = new float[bufferLength];
            System.arraycopy(this.mBuffer, this.mBuffer.length - this.mBufferOverlap, temp, 0, this.mBufferOverlap);
            this.mBuffer = temp;
        } else {
            System.arraycopy(this.mBuffer, samples.length, this.mBuffer, 0, this.mBufferOverlap);
        }
        System.arraycopy(samples, 0, this.mBuffer, this.mBufferOverlap, samples.length);
        float[] filtered = new float[samples.length / 2];
        for (int bufferPointer = 0; bufferPointer < samples.length; bufferPointer += 2) {
            FloatVector accumulator = FloatVector.zero(VECTOR_SPECIES);
            for (int coefficientPointer = 0; coefficientPointer < 64; coefficientPointer += VECTOR_SPECIES.length()) {
                FloatVector filter = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)coefficientPointer);
                FloatVector buffer = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mBuffer, (int)(bufferPointer + coefficientPointer));
                accumulator = filter.fma((Vector)buffer, (Vector)accumulator);
            }
            filtered[bufferPointer / 2] = accumulator.reduceLanes(VectorOperators.ADD);
        }
        return filtered;
    }
}

