/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.halfband;

import io.github.dsheirer.dsp.filter.decimate.IRealDecimationFilter;
import io.github.dsheirer.vector.VectorUtilities;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

public class VectorRealHalfBandDecimationFilter23Tap64Bit
implements IRealDecimationFilter {
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_64;
    private static final int COEFFICIENTS_LENGTH = 23;
    private float[] mCoefficients = new float[24];
    private float[] mBuffer;
    private int mBufferOverlap;

    public VectorRealHalfBandDecimationFilter23Tap64Bit(float[] coefficients) {
        if (coefficients.length != 23) {
            throw new IllegalArgumentException("Half-band filter coefficients must be 23 taps.  You supplied a filter with " + coefficients.length + " taps.");
        }
        VectorUtilities.checkSpecies(VECTOR_SPECIES);
        System.arraycopy(coefficients, 0, this.mCoefficients, 0, coefficients.length);
        this.mBufferOverlap = Math.max(VECTOR_SPECIES.length() - 1, coefficients.length - 1);
    }

    @Override
    public float[] decimateReal(float[] samples) {
        if (samples.length % 2 != 0) {
            throw new IllegalArgumentException("Samples array length must be an integer multiple of 2");
        }
        int bufferLength = samples.length + this.mBufferOverlap;
        if (this.mBuffer == null) {
            this.mBuffer = new float[bufferLength];
        } else if (this.mBuffer.length != bufferLength) {
            float[] temp = new float[bufferLength];
            System.arraycopy(this.mBuffer, this.mBuffer.length - this.mBufferOverlap, temp, 0, this.mBufferOverlap);
            this.mBuffer = temp;
        } else {
            System.arraycopy(this.mBuffer, samples.length, this.mBuffer, 0, this.mBufferOverlap);
        }
        System.arraycopy(samples, 0, this.mBuffer, this.mBufferOverlap, samples.length);
        float[] filtered = new float[samples.length / 2];
        FloatVector filter1 = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)0);
        FloatVector filter2 = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)2);
        FloatVector filter3 = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)4);
        FloatVector filter4 = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)6);
        FloatVector filter5 = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)8);
        FloatVector filter6 = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)10);
        FloatVector filter7 = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)12);
        FloatVector filter8 = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)14);
        FloatVector filter9 = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)16);
        FloatVector filter10 = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)18);
        FloatVector filter11 = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)20);
        FloatVector filter12 = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)22);
        for (int bufferPointer = 0; bufferPointer < samples.length; bufferPointer += 2) {
            FloatVector product1 = filter1.mul((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mBuffer, (int)bufferPointer));
            FloatVector product2 = filter2.mul((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mBuffer, (int)(bufferPointer + 2)));
            FloatVector product3 = filter3.mul((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mBuffer, (int)(bufferPointer + 4)));
            FloatVector product4 = filter4.mul((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mBuffer, (int)(bufferPointer + 6)));
            FloatVector product5 = filter5.mul((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mBuffer, (int)(bufferPointer + 8)));
            FloatVector product6 = filter6.mul((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mBuffer, (int)(bufferPointer + 10)));
            FloatVector product7 = filter7.mul((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mBuffer, (int)(bufferPointer + 12)));
            FloatVector product8 = filter8.mul((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mBuffer, (int)(bufferPointer + 14)));
            FloatVector product9 = filter9.mul((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mBuffer, (int)(bufferPointer + 16)));
            FloatVector product10 = filter10.mul((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mBuffer, (int)(bufferPointer + 18)));
            FloatVector product11 = filter11.mul((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mBuffer, (int)(bufferPointer + 20)));
            FloatVector product12 = filter12.mul((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mBuffer, (int)(bufferPointer + 22)));
            filtered[bufferPointer / 2] = product1.add((Vector)product2).add((Vector)product3).add((Vector)product4).add((Vector)product5).add((Vector)product6).add((Vector)product7).add((Vector)product8).add((Vector)product9).add((Vector)product10).add((Vector)product11).add((Vector)product12).reduceLanes(VectorOperators.ADD);
        }
        return filtered;
    }
}

