/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.halfband;

import io.github.dsheirer.dsp.filter.decimate.IRealDecimationFilter;
import io.github.dsheirer.vector.VectorUtilities;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

public class VectorRealHalfBandDecimationFilter23Tap256Bit
implements IRealDecimationFilter {
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_256;
    private static final int COEFFICIENTS_LENGTH = 23;
    private float[] mCoefficients = new float[24];
    private float[] mBuffer;
    private int mBufferOverlap;

    public VectorRealHalfBandDecimationFilter23Tap256Bit(float[] coefficients) {
        if (coefficients.length != 23) {
            throw new IllegalArgumentException("Half-band filter coefficients must be 23 taps.  You supplied a filter with " + coefficients.length + " taps.");
        }
        VectorUtilities.checkSpecies(VECTOR_SPECIES);
        System.arraycopy(coefficients, 0, this.mCoefficients, 0, coefficients.length);
        this.mBufferOverlap = Math.max(VECTOR_SPECIES.length() - 1, coefficients.length - 1);
    }

    @Override
    public float[] decimateReal(float[] samples) {
        if (samples.length % 2 != 0) {
            throw new IllegalArgumentException("Samples array length must be an integer multiple of 2");
        }
        int bufferLength = samples.length + this.mBufferOverlap;
        if (this.mBuffer == null) {
            this.mBuffer = new float[bufferLength];
        } else if (this.mBuffer.length != bufferLength) {
            float[] temp = new float[bufferLength];
            System.arraycopy(this.mBuffer, this.mBuffer.length - this.mBufferOverlap, temp, 0, this.mBufferOverlap);
            this.mBuffer = temp;
        } else {
            System.arraycopy(this.mBuffer, samples.length, this.mBuffer, 0, this.mBufferOverlap);
        }
        System.arraycopy(samples, 0, this.mBuffer, this.mBufferOverlap, samples.length);
        float[] filtered = new float[samples.length / 2];
        FloatVector filter1 = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)0);
        FloatVector filter2 = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)8);
        FloatVector filter3 = FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mCoefficients, (int)16);
        for (int bufferPointer = 0; bufferPointer < samples.length; bufferPointer += 2) {
            FloatVector product1 = filter1.mul((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mBuffer, (int)bufferPointer));
            FloatVector product2 = filter2.mul((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mBuffer, (int)(bufferPointer + 8)));
            FloatVector product3 = filter3.mul((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mBuffer, (int)(bufferPointer + 16)));
            filtered[bufferPointer / 2] = product1.add((Vector)product2).add((Vector)product3).reduceLanes(VectorOperators.ADD);
        }
        return filtered;
    }
}

