/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.halfband;

import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.decimate.IRealDecimationFilter;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter256Bit;
import io.github.dsheirer.dsp.window.WindowType;
import java.text.DecimalFormat;
import java.util.Random;

public class RealHalfBandDecimationFilter
implements IRealDecimationFilter {
    private static final float CENTER_COEFFICIENT = 0.5f;
    private float[] mCoefficients;
    private float[] mBuffer;
    private int mBufferOverlap;

    public RealHalfBandDecimationFilter(float[] coefficients) {
        if ((coefficients.length + 1) % 4 != 0) {
            throw new IllegalArgumentException("Half-band filter coefficients must be odd-length and symmetrical (length = [x * 4 + 1]");
        }
        this.mCoefficients = coefficients;
        this.mBufferOverlap = this.mCoefficients.length - 1;
    }

    @Override
    public float[] decimateReal(float[] samples) {
        if (samples.length % 2 != 0) {
            throw new IllegalArgumentException("Samples array length must be an integer multiple of 2");
        }
        int bufferLength = samples.length + this.mBufferOverlap;
        if (this.mBuffer == null) {
            this.mBuffer = new float[bufferLength];
        } else if (this.mBuffer.length != bufferLength) {
            float[] temp = new float[bufferLength];
            System.arraycopy(this.mBuffer, this.mBuffer.length - this.mBufferOverlap, temp, 0, this.mBufferOverlap);
            this.mBuffer = temp;
        } else {
            System.arraycopy(this.mBuffer, samples.length, this.mBuffer, 0, this.mBufferOverlap);
        }
        System.arraycopy(samples, 0, this.mBuffer, this.mBufferOverlap, samples.length);
        float[] filtered = new float[samples.length / 2];
        float accumulator = 0.0f;
        int half = this.mBufferOverlap / 2;
        for (int bufferPointer = 0; bufferPointer < samples.length; bufferPointer += 2) {
            accumulator = 0.0f;
            for (int coefficientPointer = 0; coefficientPointer < half; coefficientPointer += 2) {
                accumulator += this.mCoefficients[coefficientPointer] * (this.mBuffer[bufferPointer + coefficientPointer] + this.mBuffer[bufferPointer + (this.mBufferOverlap - coefficientPointer)]);
            }
            filtered[bufferPointer / 2] = accumulator += this.mBuffer[bufferPointer + half] * 0.5f;
        }
        return filtered;
    }

    public static void main(String[] args) {
        Random random = new Random();
        int sampleSize = 2048;
        float[] samples = new float[sampleSize];
        for (int x = 0; x < samples.length; ++x) {
            samples[x] = random.nextFloat() * 2.0f - 1.0f;
        }
        float[] coefficients = FilterFactory.getHalfBand(63, WindowType.BLACKMAN);
        VectorRealHalfBandDecimationFilter256Bit vectorFilter = new VectorRealHalfBandDecimationFilter256Bit(coefficients);
        double accumulator = 0.0;
        int iterations = 10000000;
        long start = System.currentTimeMillis();
        for (int x = 0; x < iterations; ++x) {
            float[] filtered = vectorFilter.decimateReal(samples);
            accumulator += (double)filtered[3];
        }
        double elapsed = System.currentTimeMillis() - start;
        DecimalFormat df = new DecimalFormat("0.000");
        System.out.println("Accumulator: " + accumulator);
        System.out.println("Test Complete.  Elapsed Time: " + df.format(elapsed / 1000.0) + " seconds");
    }
}

