/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.design;

import io.github.dsheirer.gui.control.CurveFittedAreaChart;
import java.net.URL;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.apache.commons.math3.util.FastMath;
import org.jtransforms.fft.FloatFFT_1D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterView
extends BorderPane {
    private static final Logger mLog = LoggerFactory.getLogger(FilterView.class);
    private CurveFittedAreaChart mImpulseChart;
    private NumberAxis mImpulseXAxis;
    private NumberAxis mImpulseYAxis;
    private CurveFittedAreaChart mDFTChart;
    private NumberAxis mDFTXAxis;
    private NumberAxis mDFTYAxis;
    private static final int FFT_SIZE = 4096;
    private FloatFFT_1D mFFT = new FloatFFT_1D(4096L);

    public FilterView(float[] taps) {
        this.init();
        if (taps != null) {
            this.setImpulseTaps(taps);
            float[] dft = new float[4096];
            System.arraycopy(taps, 0, dft, 0, taps.length);
            this.mFFT.realForward(dft);
            this.setDFTTaps(this.convertDFTToDecibel(dft, taps.length));
        }
    }

    private void init() {
        HBox hbox = new HBox();
        this.mImpulseXAxis = new NumberAxis(0.0, 0.5, 1.0);
        this.mImpulseYAxis = new NumberAxis(-0.2, 1.2, 0.1);
        this.mImpulseChart = new CurveFittedAreaChart(this.mImpulseXAxis, this.mImpulseYAxis);
        this.mImpulseChart.setLegendVisible(false);
        this.mImpulseChart.setHorizontalGridLinesVisible(false);
        this.mImpulseChart.setVerticalGridLinesVisible(false);
        this.mImpulseChart.setAlternativeColumnFillVisible(false);
        this.mImpulseChart.setAlternativeRowFillVisible(false);
        hbox.getChildren().add((Object)this.mImpulseChart);
        HBox.setHgrow((Node)this.mImpulseChart, (Priority)Priority.ALWAYS);
        this.mDFTXAxis = new NumberAxis(0.0, 2048.0, 512.0);
        this.mDFTYAxis = new NumberAxis(-200.0, 10.0, 10.0);
        this.mDFTChart = new CurveFittedAreaChart(this.mDFTXAxis, this.mDFTYAxis);
        this.mDFTChart.setLegendVisible(false);
        this.mDFTChart.setHorizontalGridLinesVisible(false);
        this.mDFTChart.setVerticalGridLinesVisible(false);
        this.mDFTChart.setAlternativeColumnFillVisible(false);
        this.mDFTChart.setAlternativeRowFillVisible(false);
        URL url = ((Object)((Object)this)).getClass().getResource("/../resources/FilterView.css");
        if (url != null) {
            String css = url.toExternalForm();
            this.mImpulseChart.getStylesheets().add((Object)css);
            this.mDFTChart.getStylesheets().add((Object)css);
        }
        hbox.getChildren().add((Object)this.mDFTChart);
        HBox.setHgrow((Node)this.mDFTChart, (Priority)Priority.ALWAYS);
        this.setCenter((Node)hbox);
    }

    public void setImpulseTaps(double[] taps) {
        float[] convertedTaps = new float[taps.length];
        for (int x = 0; x < taps.length; ++x) {
            convertedTaps[x] = (float)taps[x];
        }
        this.setImpulseTaps(convertedTaps);
    }

    public void setImpulseTaps(float[] taps) {
        double smallest = 0.0;
        double largest = 0.0;
        XYChart.Series series = new XYChart.Series();
        for (int x = 0; x < taps.length; ++x) {
            if ((double)taps[x] < smallest) {
                smallest = taps[x];
            }
            if ((double)taps[x] > largest) {
                largest = taps[x];
            }
            series.getData().add((Object)new XYChart.Data((Object)x, (Object)Float.valueOf(taps[x])));
        }
        this.mImpulseXAxis.setLowerBound(0.0);
        this.mImpulseXAxis.setUpperBound((double)(taps.length - 1));
        this.mImpulseXAxis.setTickUnit(1.0);
        double padding = FastMath.abs((double)(largest - smallest)) * 0.1;
        this.mImpulseYAxis.setLowerBound(smallest - padding);
        this.mImpulseYAxis.setUpperBound(largest + padding);
        this.mImpulseYAxis.setTickUnit(padding);
        ObservableList list = this.mImpulseChart.getData();
        list.add((Object)series);
    }

    public void setDFTTaps(float[] taps) {
        double smallest = 0.0;
        XYChart.Series series = new XYChart.Series();
        for (int x = 0; x < taps.length; ++x) {
            if ((double)taps[x] < smallest) {
                smallest = taps[x];
            }
            series.getData().add((Object)new XYChart.Data((Object)x, (Object)Float.valueOf(taps[x])));
        }
        ObservableList list = this.mDFTChart.getData();
        list.add((Object)series);
    }

    public float[] convertDFTToDecibel(float[] dft, int tapLength) {
        float[] decibels = new float[dft.length / 2];
        int index = 0;
        for (int x = 0; x < decibels.length; ++x) {
            index = x * 2;
            decibels[x] = 20.0f * (float)FastMath.log10((double)(dft[index] * dft[index] + dft[index + 1] * dft[index + 1]));
        }
        return decibels;
    }
}

