/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.decimate;

import io.github.dsheirer.dsp.filter.decimate.IRealDecimationFilter;
import io.github.dsheirer.dsp.filter.decimate.RealDecimateX0Filter;
import io.github.dsheirer.dsp.filter.decimate.RealDecimateX1024Filter;
import io.github.dsheirer.dsp.filter.decimate.RealDecimateX128Filter;
import io.github.dsheirer.dsp.filter.decimate.RealDecimateX16Filter;
import io.github.dsheirer.dsp.filter.decimate.RealDecimateX256Filter;
import io.github.dsheirer.dsp.filter.decimate.RealDecimateX2Filter;
import io.github.dsheirer.dsp.filter.decimate.RealDecimateX32Filter;
import io.github.dsheirer.dsp.filter.decimate.RealDecimateX4Filter;
import io.github.dsheirer.dsp.filter.decimate.RealDecimateX512Filter;
import io.github.dsheirer.dsp.filter.decimate.RealDecimateX64Filter;
import io.github.dsheirer.dsp.filter.decimate.RealDecimateX8Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecimationFilterFactory {
    private static final Logger mLog = LoggerFactory.getLogger(DecimationFilterFactory.class);
    private static final int[] SUPPORTED_RATES = new int[]{0, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};

    public static IRealDecimationFilter getRealDecimationFilter(int decimationRate) {
        switch (decimationRate) {
            case 0: {
                return new RealDecimateX0Filter();
            }
            case 2: {
                return new RealDecimateX2Filter();
            }
            case 4: {
                return new RealDecimateX4Filter();
            }
            case 8: {
                return new RealDecimateX8Filter();
            }
            case 16: {
                return new RealDecimateX16Filter();
            }
            case 32: {
                return new RealDecimateX32Filter();
            }
            case 64: {
                return new RealDecimateX64Filter();
            }
            case 128: {
                return new RealDecimateX128Filter();
            }
            case 256: {
                return new RealDecimateX256Filter();
            }
            case 512: {
                return new RealDecimateX512Filter();
            }
            case 1024: {
                return new RealDecimateX1024Filter();
            }
        }
        throw new IllegalArgumentException("Unsupported decimation rate: " + decimationRate + ".  Supported decimation rates are:" + String.valueOf(SUPPORTED_RATES));
    }

    public static int getDecimationRate(int requestedRate) {
        if (requestedRate < 0) {
            throw new IllegalArgumentException("Requested decimation rate must be greater than 2");
        }
        for (int x = SUPPORTED_RATES.length - 1; x >= 0; --x) {
            if (SUPPORTED_RATES[x] >= requestedRate) continue;
            return SUPPORTED_RATES[x];
        }
        return 2;
    }
}

