/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.dc;

import io.github.dsheirer.dsp.filter.dc.IDcRemovalFilter;
import java.util.Random;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

public class VectorDcRemovalFilter
implements IDcRemovalFilter {
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_PREFERRED;
    private float mAverageDc;
    private float mGain;

    public VectorDcRemovalFilter(float gain) {
        this.mGain = gain;
    }

    @Override
    public float[] filter(float[] samples) {
        FloatVector accumulator = FloatVector.zero(VECTOR_SPECIES);
        for (int pointer = 0; pointer < samples.length; pointer += VECTOR_SPECIES.length()) {
            accumulator = accumulator.add((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])samples, (int)pointer));
        }
        float sum = accumulator.reduceLanes(VectorOperators.ADD);
        float average = this.mAverageDc;
        float averageDCNow = sum / (float)samples.length - average;
        average += this.mGain * averageDCNow;
        for (int pointer = 0; pointer < samples.length; pointer += VECTOR_SPECIES.length()) {
            FloatVector.fromArray(VECTOR_SPECIES, (float[])samples, (int)pointer).add(average).intoArray(samples, pointer);
        }
        this.mAverageDc = average;
        return samples;
    }

    public static void main(String[] args) {
        System.out.println("Starting ...");
        Random random = new Random();
        VectorDcRemovalFilter filter = new VectorDcRemovalFilter(0.15f);
        float dcOffset = 0.03f;
        for (int x = 0; x < 10; ++x) {
            float[] samples = new float[8192];
            for (int y = 0; y < samples.length; ++y) {
                samples[y] = random.nextFloat() * 2.0f - 1.0f + dcOffset;
            }
            samples = filter.filter(samples);
        }
        System.out.println("Finished!");
    }
}

