/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.channelizer.output;

import io.github.dsheirer.dsp.filter.channelizer.output.ChannelOutputProcessor;
import io.github.dsheirer.dsp.filter.channelizer.output.TwoChannelMixerAssembler;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.source.heartbeat.HeartbeatManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoChannelOutputProcessor
extends ChannelOutputProcessor {
    private static final Logger mLog = LoggerFactory.getLogger(TwoChannelOutputProcessor.class);
    private TwoChannelMixerAssembler mMixerAssembler;
    private int mChannelOffset1;
    private int mChannelOffset2;

    public TwoChannelOutputProcessor(double sampleRate, List<Integer> channelIndexes, float[] filter, float gain, HeartbeatManager heartbeatManager) {
        super(2, sampleRate, heartbeatManager);
        this.setPolyphaseChannelIndices(channelIndexes);
        this.mMixerAssembler = new TwoChannelMixerAssembler(gain);
        this.mMixerAssembler.getMixer().setSampleRate(sampleRate);
        this.setSynthesisFilter(filter);
    }

    @Override
    public String getStateDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Two Channel Output Processor");
        sb.append("\n\tIndices (doubled) 1 [").append(this.mChannelOffset1).append("] 2 [").append(this.mChannelOffset2).append("]");
        sb.append("\n\tMixer Assembler: ").append(this.mMixerAssembler.getStateDescription());
        return sb.toString();
    }

    @Override
    public void setFrequencyOffset(long frequencyOffset) {
        this.mMixerAssembler.getMixer().setFrequency(frequencyOffset);
    }

    @Override
    public void setSynthesisFilter(float[] filter) {
        this.mMixerAssembler.setSynthesisFilter(filter);
    }

    @Override
    public void setPolyphaseChannelIndices(List<Integer> indexes) {
        if (indexes.size() != 2) {
            throw new IllegalArgumentException("Double channel output processor requires two indexes to process - provided indexes " + String.valueOf(indexes));
        }
        this.mChannelOffset1 = indexes.get(0) * 2;
        this.mChannelOffset2 = indexes.get(1) * 2;
    }

    @Override
    public void process(List<float[]> channelResultsList) {
        for (float[] channelResults : channelResultsList) {
            this.mMixerAssembler.receive(channelResults[this.mChannelOffset1], channelResults[this.mChannelOffset1 + 1], channelResults[this.mChannelOffset2], channelResults[this.mChannelOffset2 + 1]);
            if (!this.mMixerAssembler.hasBuffer()) continue;
            ComplexSamples buffer = this.mMixerAssembler.getBuffer(this.getCurrentSampleTimestamp());
            if (this.mComplexSamplesListener == null) continue;
            try {
                this.mComplexSamplesListener.receive(buffer);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception e) {
                mLog.error("Error extracting channel samples from two polyphase channel results buffer", (Throwable)e);
            }
        }
    }
}

