/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.channelizer.output;

import io.github.dsheirer.dsp.filter.channelizer.TwoChannelSynthesizerM2;
import io.github.dsheirer.dsp.filter.channelizer.output.MixerAssembler;
import io.github.dsheirer.dsp.filter.channelizer.output.SampleAssembler;
import io.github.dsheirer.dsp.oscillator.FS4DownConverter;
import io.github.dsheirer.sample.complex.ComplexSamples;

public class TwoChannelMixerAssembler
extends MixerAssembler {
    private SampleAssembler mChannel1SampleAssembler = new SampleAssembler(2048);
    private SampleAssembler mChannel2SampleAssembler = new SampleAssembler(2048);
    private FS4DownConverter mFS4DownConverter = new FS4DownConverter();
    private TwoChannelSynthesizerM2 mTwoChannelSynthesizer;

    public TwoChannelMixerAssembler(float gain) {
        super(gain);
    }

    public String getStateDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Two Channel Mixer Assembler - State Description:");
        sb.append("\n\tTwo-Channel Synthesizer: ").append(this.mTwoChannelSynthesizer.getStateDescription());
        sb.append("\n\tMixer Frequency: ").append(this.getMixer().getFrequency());
        sb.append("\n\tGain: ").append(this.getGain().getGain());
        return sb.toString();
    }

    public void setSynthesisFilter(float[] filter) {
        this.mTwoChannelSynthesizer = new TwoChannelSynthesizerM2(filter);
    }

    public void receive(float iChannel1, float qChannel1, float iChannel2, float qChannel2) {
        this.mChannel1SampleAssembler.receive(iChannel1, qChannel1);
        this.mChannel2SampleAssembler.receive(iChannel2, qChannel2);
    }

    @Override
    public boolean hasBuffer() {
        return this.mChannel1SampleAssembler.hasBuffer();
    }

    @Override
    public ComplexSamples getBuffer(long timestamp) {
        ComplexSamples channel1 = this.mChannel1SampleAssembler.getBufferAndReset(timestamp);
        ComplexSamples channel2 = this.mChannel2SampleAssembler.getBufferAndReset(timestamp);
        ComplexSamples buffer = this.mTwoChannelSynthesizer.process(channel1, channel2);
        buffer = this.mFS4DownConverter.mixComplex(buffer);
        if (this.getMixer().hasFrequency()) {
            buffer = this.getMixer().mix(buffer);
        }
        buffer = this.getGain().apply(buffer);
        return buffer;
    }
}

