/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.channelizer;

import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.design.FilterDesignException;
import java.util.HashMap;
import java.util.Map;

public class SynthesisFilterManager {
    private static final int POLYPHASE_SYNTHESIZER_TAPS_PER_CHANNEL = 9;
    private static final String SEPARATOR = "-";
    private Map<String, float[]> mFilterMap = new HashMap<String, float[]>();

    public float[] getFilter(double sampleRate, double channelBandwidth, int channelCount) throws FilterDesignException {
        String key = sampleRate + SEPARATOR + channelBandwidth + SEPARATOR + channelCount;
        if (this.mFilterMap.containsKey(key)) {
            return this.mFilterMap.get(key);
        }
        float[] taps = FilterFactory.getSincM2Synthesizer(sampleRate, channelBandwidth, channelCount, 9);
        this.mFilterMap.put(key, taps);
        return taps;
    }
}

