/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.channelizer;

import io.github.dsheirer.dsp.filter.channelizer.ChannelCalculator;
import io.github.dsheirer.dsp.filter.channelizer.SynthesisFilterManager;
import io.github.dsheirer.dsp.filter.channelizer.output.IPolyphaseChannelOutputProcessor;
import io.github.dsheirer.dsp.filter.channelizer.output.OneChannelOutputProcessor;
import io.github.dsheirer.dsp.filter.channelizer.output.TwoChannelOutputProcessor;
import io.github.dsheirer.dsp.filter.design.FilterDesignException;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import io.github.dsheirer.source.tuner.channel.TunerChannelSource;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolyphaseChannelSource
extends TunerChannelSource
implements Listener<ComplexSamples> {
    private Logger mLog = LoggerFactory.getLogger(PolyphaseChannelSource.class);
    private IPolyphaseChannelOutputProcessor mPolyphaseChannelOutputProcessor;
    private Listener<ComplexSamples> mSamplesListener;
    private double mChannelSampleRate;
    private long mIndexCenterFrequency;
    private List<Integer> mOutputProcessorIndexes = new ArrayList<Integer>();
    private double mTunerSampleRate;
    private double mTunerCenterFrequency;
    private PendingOutputProcessorUpdate mPendingOutputProcessorUpdate;

    public PolyphaseChannelSource(TunerChannel tunerChannel, ChannelCalculator channelCalculator, SynthesisFilterManager filterManager, Listener<SourceEvent> producerSourceEventListener) throws IllegalArgumentException {
        super(producerSourceEventListener, tunerChannel);
        this.mChannelSampleRate = channelCalculator.getChannelSampleRate();
        this.doUpdateOutputProcessor(channelCalculator, filterManager);
    }

    public String getStateDescription() {
        return this.mPolyphaseChannelOutputProcessor.getStateDescription();
    }

    public List<Integer> getOutputProcessorIndexes() {
        return this.mOutputProcessorIndexes;
    }

    public double getTunerSampleRate() {
        return this.mTunerSampleRate;
    }

    public double getTunerCenterFrequency() {
        return this.mTunerCenterFrequency;
    }

    @Override
    public void start() {
        super.start();
        if (this.mPolyphaseChannelOutputProcessor != null) {
            this.mPolyphaseChannelOutputProcessor.start();
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.mPolyphaseChannelOutputProcessor != null) {
            this.mPolyphaseChannelOutputProcessor.stop();
        }
    }

    @Override
    public void setListener(Listener<ComplexSamples> listener) {
        this.mSamplesListener = listener;
        this.mPolyphaseChannelOutputProcessor.setListener(this);
    }

    @Override
    public void receive(ComplexSamples complexSamples) {
        if (this.mSamplesListener != null) {
            try {
                this.mSamplesListener.receive(complexSamples);
            }
            catch (Throwable t) {
                this.mLog.error("Error dispatching complex samples to listener [" + String.valueOf(this.mSamplesListener.getClass()) + "]", t);
            }
        }
    }

    public void updateOutputProcessor(ChannelCalculator channelCalculator, SynthesisFilterManager filterManager) throws IllegalArgumentException {
        this.mPendingOutputProcessorUpdate = new PendingOutputProcessorUpdate(this, channelCalculator, filterManager);
    }

    public void doUpdateOutputProcessor(ChannelCalculator channelCalculator, SynthesisFilterManager filterManager) throws IllegalArgumentException {
        String errorMessage = null;
        List<Integer> indexes = channelCalculator.getChannelIndexes(this.getTunerChannel());
        this.mOutputProcessorIndexes.clear();
        this.mOutputProcessorIndexes.addAll(indexes);
        this.mTunerCenterFrequency = channelCalculator.getCenterFrequency();
        this.mTunerSampleRate = channelCalculator.getSampleRate();
        this.setFrequency(channelCalculator.getCenterFrequencyForIndexes(indexes));
        if (this.mPolyphaseChannelOutputProcessor != null && this.mPolyphaseChannelOutputProcessor.getInputChannelCount() == indexes.size()) {
            this.mPolyphaseChannelOutputProcessor.setPolyphaseChannelIndices(indexes);
            if (indexes.size() > 1) {
                try {
                    float[] filter = filterManager.getFilter(channelCalculator.getChannelSampleRate(), channelCalculator.getChannelBandwidth(), indexes.size());
                    this.mPolyphaseChannelOutputProcessor.setSynthesisFilter(filter);
                }
                catch (FilterDesignException fde) {
                    this.mLog.error("Error creating an updated synthesis filter for the channel output processor");
                    errorMessage = "Cannot update output processor - unable to design synthesis filter for [" + indexes.size() + "] channel indices - channel sample rate [" + channelCalculator.getChannelSampleRate() + "] channel bandwidth [" + channelCalculator.getChannelBandwidth() + "]";
                }
            }
            this.mPolyphaseChannelOutputProcessor.setFrequencyOffset(this.getFrequencyOffset());
        } else {
            if (this.mPolyphaseChannelOutputProcessor != null) {
                this.mPolyphaseChannelOutputProcessor.setListener(null);
                this.mPolyphaseChannelOutputProcessor.stop();
            }
            this.mPolyphaseChannelOutputProcessor = null;
            switch (indexes.size()) {
                case 1: {
                    this.mPolyphaseChannelOutputProcessor = new OneChannelOutputProcessor(channelCalculator.getChannelSampleRate(), indexes, channelCalculator.getChannelCount(), this.getHeartbeatManager());
                    this.mPolyphaseChannelOutputProcessor.setListener(this);
                    this.mPolyphaseChannelOutputProcessor.setFrequencyOffset(this.getFrequencyOffset());
                    this.mPolyphaseChannelOutputProcessor.start();
                    break;
                }
                case 2: {
                    try {
                        float[] filter = filterManager.getFilter(channelCalculator.getChannelSampleRate(), channelCalculator.getChannelBandwidth(), 2);
                        this.mPolyphaseChannelOutputProcessor = new TwoChannelOutputProcessor(channelCalculator.getChannelSampleRate(), indexes, filter, channelCalculator.getChannelCount(), this.getHeartbeatManager());
                        this.mPolyphaseChannelOutputProcessor.setListener(this);
                        this.mPolyphaseChannelOutputProcessor.setFrequencyOffset(this.getFrequencyOffset());
                        this.mPolyphaseChannelOutputProcessor.start();
                    }
                    catch (FilterDesignException fde) {
                        errorMessage = "Cannot create new output processor - unable to design synthesis filter for [" + indexes.size() + "] channel indices";
                        this.mLog.error("Error creating a synthesis filter for a new channel output processor");
                    }
                    break;
                }
                default: {
                    this.mLog.error("Request to create an output processor for unexpected channel index size:" + indexes.size());
                    this.mLog.info(channelCalculator.toString());
                    errorMessage = "Unable to create new channel output processor - unexpected channel index size: " + indexes.size();
                }
            }
        }
        if (errorMessage != null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public void receiveChannelResults(List<float[]> channelResultsList, long currentSamplesTimestamp) {
        if (this.mPendingOutputProcessorUpdate != null) {
            ChannelCalculator channelCalculator = this.mPendingOutputProcessorUpdate.getChannelCalculator();
            SynthesisFilterManager filterManager = this.mPendingOutputProcessorUpdate.getSynthesisFilterManager();
            this.mPendingOutputProcessorUpdate = null;
            this.doUpdateOutputProcessor(channelCalculator, filterManager);
        }
        try {
            if (this.mPolyphaseChannelOutputProcessor != null) {
                this.mPolyphaseChannelOutputProcessor.receiveChannelResults(channelResultsList, currentSamplesTimestamp);
            }
        }
        catch (Exception e) {
            this.mLog.error("Error processing channel results", (Throwable)e);
        }
    }

    @Override
    public double getSampleRate() {
        return this.mChannelSampleRate;
    }

    @Override
    protected void setSampleRate(double sampleRate) {
        this.mChannelSampleRate = sampleRate;
    }

    @Override
    public void dispose() {
        if (this.mPolyphaseChannelOutputProcessor != null) {
            this.mPolyphaseChannelOutputProcessor.setListener(null);
            this.mPolyphaseChannelOutputProcessor.dispose();
        }
    }

    @Override
    public void setFrequency(long frequency) {
        this.mIndexCenterFrequency = frequency;
    }

    public long getIndexCenterFrequency() {
        return this.mIndexCenterFrequency;
    }

    public long getFrequencyOffset() {
        return this.mIndexCenterFrequency - this.getTunerChannel().getFrequency();
    }

    public String toString() {
        return "POLYPHASE [" + this.mPolyphaseChannelOutputProcessor.getInputChannelCount() + "] " + this.getTunerChannel().getFrequency();
    }

    public class PendingOutputProcessorUpdate {
        private final ChannelCalculator mChannelCalculator;
        private final SynthesisFilterManager mSynthesisFilterManager;

        public PendingOutputProcessorUpdate(PolyphaseChannelSource this$0, ChannelCalculator channelCalculator, SynthesisFilterManager synthesisFilterManager) {
            this.mChannelCalculator = channelCalculator;
            this.mSynthesisFilterManager = synthesisFilterManager;
        }

        public ChannelCalculator getChannelCalculator() {
            return this.mChannelCalculator;
        }

        public SynthesisFilterManager getSynthesisFilterManager() {
            return this.mSynthesisFilterManager;
        }
    }
}

