/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter.channelizer;

import io.github.dsheirer.source.tuner.channel.TunerChannel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelCalculator {
    private static final DecimalFormat FREQUENCY_FORMAT = new DecimalFormat("0.00000");
    private static final Logger mLog = LoggerFactory.getLogger(ChannelCalculator.class);
    private double mSampleRate;
    private int mChannelCount;
    private double mCenterFrequency;
    private double mChannelBandwidth;
    private double mOversampling = 2.0;

    public ChannelCalculator(double sampleRate, int channelCount, double centerFrequency, double oversampling) {
        this.mSampleRate = sampleRate;
        this.mChannelCount = channelCount;
        this.mCenterFrequency = centerFrequency;
        this.mOversampling = oversampling;
        this.updateChannelBandwidth();
    }

    private void updateChannelBandwidth() {
        this.mChannelBandwidth = this.mSampleRate / (double)this.mChannelCount;
    }

    public double getCenterFrequency() {
        return this.mCenterFrequency;
    }

    public void setCenterFrequency(double frequency) {
        this.mCenterFrequency = frequency;
    }

    public int getChannelCount() {
        return this.mChannelCount;
    }

    public void setChannelCount(int channelCount) {
        this.mChannelCount = channelCount;
        this.updateChannelBandwidth();
    }

    public int getWrapAroundIndex() {
        return this.mChannelCount / 2;
    }

    public double getSampleRate() {
        return this.mSampleRate;
    }

    public void setRates(double sampleRate, int channelCount) {
        this.mSampleRate = sampleRate;
        this.mChannelCount = channelCount;
        this.updateChannelBandwidth();
    }

    public double getChannelBandwidth() {
        return this.mChannelBandwidth;
    }

    public double getHalfChannelBandwidth() {
        return this.mChannelBandwidth / 2.0;
    }

    public double getOversampling() {
        return this.mOversampling;
    }

    public void setOversampling(double oversampling) {
        this.mOversampling = oversampling;
    }

    public double getChannelSampleRate() {
        return this.getChannelBandwidth() * this.getOversampling();
    }

    public long getMinimumFrequency() {
        return (long)(this.getCenterFrequency() - this.getSampleRate() / 2.0);
    }

    public long getMaximumFrequency() {
        return (long)(this.getCenterFrequency() + this.getSampleRate() / 2.0);
    }

    public List<Integer> getChannelIndexes(TunerChannel tunerChannel) throws IllegalArgumentException {
        if (tunerChannel.getMinFrequency() < this.getMinimumFrequency() || tunerChannel.getMaxFrequency() > this.getMaximumFrequency()) {
            throw new IllegalArgumentException("Requested channel cannot be provided by this channelizer.  Requested channel [" + tunerChannel.getMinFrequency() + " - " + tunerChannel.getMaxFrequency() + "] exceeds current channelizer frequency range [" + this.getMinimumFrequency() + " - " + this.getMaximumFrequency() + "]");
        }
        int minIndex = this.getIndexForFrequency(tunerChannel.getMinFrequency(), IndexBoundaryPolicy.ADJUST_POSITIVE);
        int maxIndex = this.getIndexForFrequency(tunerChannel.getMaxFrequency(), IndexBoundaryPolicy.ADJUST_NEGATIVE);
        if (minIndex == this.getWrapAroundIndex() && maxIndex == this.getWrapAroundIndex()) {
            throw new IllegalArgumentException("Requested tuner channel cannot be provided.  Requested bandwidth is within two channel bandwidths of the sample rate.");
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        indexes.add(minIndex);
        if (minIndex != maxIndex) {
            if (minIndex < 0 || minIndex >= this.getChannelCount() || maxIndex < 0 || maxIndex >= this.getChannelCount()) {
                throw new IllegalArgumentException("Something went wrong while calculating the min and max polyphase channel indexes for tuner channel: " + String.valueOf(tunerChannel));
            }
            int pointer = minIndex + 1;
            if (pointer >= this.getChannelCount()) {
                pointer -= this.getChannelCount();
            }
            while (pointer != maxIndex) {
                indexes.add(pointer);
                if (++pointer < this.getChannelCount()) continue;
                pointer -= this.getChannelCount();
            }
            indexes.add(maxIndex);
        }
        return indexes;
    }

    public int getIndexForFrequency(long frequency, IndexBoundaryPolicy indexBoundaryPolicy) {
        double offset = (double)frequency - this.getCenterFrequency();
        if (FastMath.abs((double)offset) < this.getHalfChannelBandwidth()) {
            return 0;
        }
        offset = offset > 0.0 ? (offset += this.getHalfChannelBandwidth()) : (offset -= this.getHalfChannelBandwidth());
        int indexOffset = (int)(offset / this.getChannelBandwidth());
        if (indexOffset < 0) {
            indexOffset += this.getChannelCount();
        }
        if (indexBoundaryPolicy == IndexBoundaryPolicy.ADJUST_POSITIVE && this.isOverlapFrequency(frequency, indexOffset, indexOffset + 1)) {
            indexOffset = this.normalize(indexOffset + 1);
        } else if (indexBoundaryPolicy == IndexBoundaryPolicy.ADJUST_NEGATIVE && this.isOverlapFrequency(frequency, indexOffset - 1, indexOffset)) {
            indexOffset = this.normalize(indexOffset - 1);
        }
        return indexOffset;
    }

    public boolean isOverlapFrequency(long frequency, int index1, int index2) {
        index1 = this.normalize(index1);
        int delta = this.normalize((index2 = this.normalize(index2)) - index1);
        if (delta != 1) {
            return false;
        }
        long index1MaximumFrequency = (long)this.getIndexMaximumFrequency(index1, IndexBoundaryPolicy.ADJUST_POSITIVE);
        long index2MinimumFrequency = (long)this.getIndexMinimumFrequency(index2, IndexBoundaryPolicy.ADJUST_NEGATIVE);
        if (index1 == this.getWrapAroundIndex()) {
            index1MaximumFrequency = (long)this.getIndexMaximumFrequency(index1, IndexBoundaryPolicy.ADJUST_NEGATIVE);
        }
        if (index2 == this.getWrapAroundIndex()) {
            index2MinimumFrequency = (long)this.getIndexMinimumFrequency(index2, IndexBoundaryPolicy.ADJUST_POSITIVE);
        }
        return frequency == index1MaximumFrequency && frequency == index2MinimumFrequency;
    }

    private int normalize(int index) {
        while (index < 0) {
            index += this.getChannelCount();
        }
        while (index >= this.getChannelCount()) {
            index -= this.getChannelCount();
        }
        return index;
    }

    public double getIndexCenterFrequency(int index, IndexBoundaryPolicy indexBoundaryPolicy) {
        if (index < 0 || index >= this.getChannelCount()) {
            throw new IllegalArgumentException("Illegal channel index [" + index + "] current max channels[" + this.getChannelCount() + "]");
        }
        int wrapAroundIndex = this.getWrapAroundIndex();
        if (index == wrapAroundIndex) {
            if (indexBoundaryPolicy == IndexBoundaryPolicy.ADJUST_POSITIVE) {
                return this.getCenterFrequency() + (double)index * this.getChannelBandwidth();
            }
            return this.getCenterFrequency() - (double)index * this.getChannelBandwidth();
        }
        if (index < wrapAroundIndex) {
            return this.getCenterFrequency() + (double)index * this.getChannelBandwidth();
        }
        return this.getCenterFrequency() - (double)(this.getChannelCount() - index) * this.getChannelBandwidth();
    }

    public double getIndexMinimumFrequency(int index, IndexBoundaryPolicy indexBoundaryPolicy) {
        if (index < 0 || index >= this.getChannelCount()) {
            throw new IllegalArgumentException("Can't determine minimum frequency - illegal channel index [" + index + "]");
        }
        int wrapAroundIndex = this.getWrapAroundIndex();
        if (index == wrapAroundIndex) {
            if (indexBoundaryPolicy == IndexBoundaryPolicy.ADJUST_POSITIVE) {
                return this.getCenterFrequency() + (double)index * this.getChannelBandwidth() - this.getHalfChannelBandwidth();
            }
            return this.getIndexCenterFrequency(index, indexBoundaryPolicy);
        }
        if (index <= wrapAroundIndex) {
            return this.getCenterFrequency() + (double)index * this.getChannelBandwidth() - this.getHalfChannelBandwidth();
        }
        return this.getCenterFrequency() - (double)(this.getChannelCount() - index) * this.getChannelBandwidth() - this.getHalfChannelBandwidth();
    }

    public double getIndexMaximumFrequency(int index, IndexBoundaryPolicy indexBoundaryPolicy) {
        if (index < 0 || index >= this.getChannelCount()) {
            throw new IllegalArgumentException("Can't determine maximum frequency - illegal channel index [" + index + "]");
        }
        int wrapAroundIndex = this.getWrapAroundIndex();
        if (index == wrapAroundIndex) {
            if (indexBoundaryPolicy == IndexBoundaryPolicy.ADJUST_POSITIVE) {
                return this.getIndexCenterFrequency(index, indexBoundaryPolicy);
            }
            return this.getCenterFrequency() - ((double)index * this.getChannelBandwidth() - this.getHalfChannelBandwidth());
        }
        if (index <= wrapAroundIndex) {
            return this.getCenterFrequency() + (double)index * this.getChannelBandwidth() + this.getHalfChannelBandwidth();
        }
        return this.getCenterFrequency() - (double)(this.getChannelCount() - index) * this.getChannelBandwidth() + this.getHalfChannelBandwidth();
    }

    public long getCenterFrequencyForIndexes(List<Integer> indexes) {
        if (indexes.isEmpty()) {
            throw new IllegalArgumentException("Indexes cannot be empty");
        }
        int centerIndex = (indexes.size() - 1) / 2;
        int index = indexes.get(centerIndex);
        if (indexes.size() % 2 == 0) {
            return (long)this.getIndexMaximumFrequency(index, IndexBoundaryPolicy.ADJUST_NEGATIVE);
        }
        if (index == this.getWrapAroundIndex()) {
            return (long)this.getIndexCenterFrequency(index, IndexBoundaryPolicy.ADJUST_NEGATIVE);
        }
        return (long)this.getIndexCenterFrequency(index, IndexBoundaryPolicy.ADJUST_POSITIVE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Channel Calculator | Tuner SR:").append(FREQUENCY_FORMAT.format(this.getSampleRate() / 1000000.0));
        sb.append(" CF:").append(FREQUENCY_FORMAT.format(this.getCenterFrequency() / 1000000.0));
        sb.append(" MIN:").append(FREQUENCY_FORMAT.format((double)this.getMinimumFrequency() / 1000000.0));
        sb.append(" MAX:").append(FREQUENCY_FORMAT.format((double)this.getMaximumFrequency() / 1000000.0));
        sb.append(" | Channel COUNT:").append(this.getChannelCount());
        sb.append(" BW:").append(FREQUENCY_FORMAT.format(this.getChannelBandwidth() / 1000000.0));
        sb.append(" SR:").append(FREQUENCY_FORMAT.format(this.getChannelSampleRate() / 1000000.0));
        return sb.toString();
    }

    public static enum IndexBoundaryPolicy {
        ADJUST_POSITIVE,
        ADJUST_NEGATIVE;

    }
}

