/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.filter;

import io.github.dsheirer.dsp.filter.decimate.IRealDecimationFilter;
import io.github.dsheirer.dsp.filter.design.FilterDesignException;
import io.github.dsheirer.dsp.filter.fir.FIRFilterSpecification;
import io.github.dsheirer.dsp.filter.fir.real.IRealFilter;
import io.github.dsheirer.dsp.filter.fir.real.RealFIRFilter;
import io.github.dsheirer.dsp.filter.fir.real.VectorRealFIRFilter128Bit;
import io.github.dsheirer.dsp.filter.fir.real.VectorRealFIRFilter256Bit;
import io.github.dsheirer.dsp.filter.fir.real.VectorRealFIRFilter512Bit;
import io.github.dsheirer.dsp.filter.fir.real.VectorRealFIRFilter64Bit;
import io.github.dsheirer.dsp.filter.fir.real.VectorRealFIRFilterDefaultBit;
import io.github.dsheirer.dsp.filter.fir.remez.RemezFIRFilterDesigner;
import io.github.dsheirer.dsp.filter.fir.remez.RemezFIRFilterDesignerWithLagrange;
import io.github.dsheirer.dsp.filter.halfband.RealHalfBandDecimationFilter;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter11Tap128Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter11Tap256Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter11Tap512Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter11Tap64Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter128Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter15Tap128Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter15Tap256Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter15Tap512Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter15Tap64Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter23Tap128Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter23Tap256Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter23Tap512Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter23Tap64Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter256Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter512Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter63Tap128Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter63Tap256Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter63Tap512Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter63Tap64Bit;
import io.github.dsheirer.dsp.filter.halfband.VectorRealHalfBandDecimationFilter64Bit;
import io.github.dsheirer.dsp.window.WindowFactory;
import io.github.dsheirer.dsp.window.WindowType;
import io.github.dsheirer.vector.calibrate.CalibrationManager;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import java.text.DecimalFormat;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.math3.util.FastMath;
import org.jtransforms.fft.FloatFFT_1D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterFactory {
    private static final Logger mLog = LoggerFactory.getLogger(FilterFactory.class);
    private static final double PERFECT_RECONSTRUCTION_GAIN_AT_BAND_EDGE = (double)-6.0206f;
    private static final double MARGIN_OF_ERROR = 3.0E-4;

    public static float[] getSinc(double sampleRate, long frequency, int length, WindowType window) {
        int evenLength = length % 2 == 0 ? length : length + 1;
        float[] frequencyResponse = FilterFactory.getUnityResponseArray(sampleRate, frequency, evenLength);
        FloatFFT_1D idft = new FloatFFT_1D((long)evenLength);
        idft.realInverseFull(frequencyResponse, true);
        float[] coefficients = new float[length];
        int middleCoefficient = length / 2;
        if (length % 2 == 0) {
            for (int x = 0; x < middleCoefficient; ++x) {
                coefficients[middleCoefficient + x] = frequencyResponse[2 * x];
                coefficients[middleCoefficient - x] = frequencyResponse[2 * x];
            }
        } else {
            coefficients[middleCoefficient] = frequencyResponse[0];
            for (int x = 1; x < middleCoefficient; ++x) {
                coefficients[middleCoefficient + x] = frequencyResponse[2 * x];
                coefficients[middleCoefficient - x] = frequencyResponse[2 * x];
            }
        }
        coefficients = WindowFactory.apply(window, coefficients);
        return coefficients;
    }

    public static float[] normalize(float[] coefficients) {
        float accumulator = 0.0f;
        for (float coefficient : coefficients) {
            accumulator += FastMath.abs((float)coefficient);
        }
        for (int x = 0; x < coefficients.length; ++x) {
            coefficients[x] = coefficients[x] / accumulator;
        }
        return coefficients;
    }

    public static float[] normalize(float[] coefficients, float objective) {
        float accumulator = 0.0f;
        for (float coefficient : coefficients) {
            accumulator += FastMath.abs((float)coefficient);
        }
        accumulator /= objective;
        for (int x = 0; x < coefficients.length; ++x) {
            coefficients[x] = coefficients[x] / accumulator;
        }
        return coefficients;
    }

    public static float[] getUnityResponseArray(double sampleRate, long frequency, int length) {
        float[] unityArray = new float[length * 2];
        if (length % 2 == 0) {
            int binCount = FastMath.round((float)((float)frequency / (float)sampleRate * (float)length));
            for (int x = 0; x < binCount; ++x) {
                unityArray[x] = 1.0f;
                unityArray[length - 1 - x] = 1.0f;
            }
        } else {
            int binCount = (int)FastMath.round((double)((double)((float)frequency / (float)sampleRate * (float)length) + 0.5));
            unityArray[0] = 1.0f;
            for (int x = 1; x < binCount; ++x) {
                unityArray[x] = 1.0f;
                unityArray[length - x] = 1.0f;
            }
        }
        return unityArray;
    }

    public static float[] invert(float[] coefficients) {
        for (int x = 1; x < coefficients.length; x += 2) {
            coefficients[x] = -coefficients[x];
        }
        return coefficients;
    }

    public static float[] getLowPass(double sampleRate, long cutoff, int filterLength, WindowType windowType) {
        return FilterFactory.getSinc(sampleRate, cutoff, filterLength, windowType);
    }

    public static float[] getLowPass(double sampleRate, int passFrequency, int stopFrequency, int attenuation, WindowType windowType, boolean forceOddLength) {
        if (stopFrequency < passFrequency || (double)stopFrequency > sampleRate / 2.0) {
            throw new IllegalArgumentException("FilterFactory - low pass filter pass frequency [" + passFrequency + "] must be less than the stop frequency [" + stopFrequency + "] and must be less than half [" + (int)(sampleRate / 2.0) + "] of the sample rate [" + sampleRate + "]");
        }
        int tapCount = FilterFactory.getTapCount(sampleRate, passFrequency, stopFrequency, attenuation);
        if (forceOddLength && tapCount % 2 == 0) {
            --tapCount;
        }
        return FilterFactory.getLowPass(sampleRate, passFrequency, tapCount, windowType);
    }

    public static float[] getHighPass(int sampleRate, long cutoff, int filterLength, WindowType windowType) {
        long convertedCutoff = (long)(sampleRate / 2) - cutoff;
        return FilterFactory.invert(FilterFactory.getSinc(sampleRate, convertedCutoff, filterLength, windowType));
    }

    public static float[] getHighPass(int sampleRate, long stopFrequency, long passFrequency, int attenuation, WindowType windowType, boolean forceOddLength) {
        int tapCount = FilterFactory.getTapCount(sampleRate, stopFrequency, passFrequency, attenuation);
        if (forceOddLength && tapCount % 2 == 0) {
            --tapCount;
        }
        return FilterFactory.invert(FilterFactory.getLowPass(sampleRate, stopFrequency, tapCount, windowType));
    }

    public static String arrayToString(float[] array, boolean breaks) {
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < array.length; ++x) {
            sb.append(x).append(": ").append(array[x]);
            if (breaks) {
                sb.append("\n");
                continue;
            }
            if (x % 8 == 7) {
                sb.append("\n");
                continue;
            }
            sb.append("\t");
        }
        return sb.toString();
    }

    public static int getTapCount(double sampleRate, long pass, long stop, int attenuation) {
        double frequency = ((double)stop - (double)pass) / sampleRate;
        return (int)FastMath.round((double)((double)attenuation / (22.0 * frequency)));
    }

    public static int[] getPolyphaseDecimationRates(int sampleRate, int decimatedRate, long passFrequency, long stopFrequency) {
        Set<Integer> factors;
        if (sampleRate % decimatedRate != 0) {
            throw new IllegalArgumentException("Decimated rate must be an integer multiple of sample rate");
        }
        int decimation = sampleRate / decimatedRate;
        if (decimation < 20) {
            int[] rates = new int[]{decimation};
            return rates;
        }
        int optimalStage1 = FilterFactory.getOptimalStageOneRate(sampleRate, decimation, passFrequency, stopFrequency);
        int stage1 = FilterFactory.findClosest(optimalStage1, factors = FilterFactory.getFactors(decimation));
        if (stage1 == decimation || stage1 == 1) {
            int[] rates = new int[]{decimation};
            return rates;
        }
        int[] rates = new int[2];
        int stage2 = decimation / stage1;
        if (stage1 > stage2) {
            rates[0] = stage1;
            rates[1] = stage2;
        } else {
            rates[0] = stage2;
            rates[1] = stage1;
        }
        return rates;
    }

    private static int findClosest(int desiredFactor, Set<Integer> factors) {
        int bestFactor = 1;
        int bestDelta = desiredFactor;
        for (Integer factor : factors) {
            int testDelta = FastMath.abs((int)(desiredFactor - factor));
            if (testDelta >= bestDelta) continue;
            bestDelta = testDelta;
            bestFactor = factor;
        }
        return bestFactor;
    }

    private static Set<Integer> getFactors(int value) {
        TreeSet<Integer> factors = new TreeSet<Integer>();
        for (int x = 1; x <= value; ++x) {
            int remainder = value / x;
            if (remainder * x != value) continue;
            factors.add(x);
        }
        return factors;
    }

    public static int getOptimalStageOneRate(int sampleRate, int decimation, long passFrequency, long stopFrequency) {
        double ratio = FilterFactory.getBandwidthRatio(passFrequency, stopFrequency);
        double numerator = 1.0 - FastMath.sqrt((double)((double)decimation * ratio / (2.0 - ratio)));
        double denominator = 2.0 - ratio * ((double)decimation + 1.0);
        int retVal = (int)(2.0 * (double)decimation * (numerator / denominator));
        return retVal;
    }

    private static double getBandwidthRatio(long passFrequency, long stopFrequency) {
        assert (passFrequency < stopFrequency);
        return (double)(stopFrequency - passFrequency) / (double)stopFrequency;
    }

    public static float[] getCICCleanupFilter(int outputSampleRate, int passFrequency, int attenuation, WindowType window) {
        int taps = FilterFactory.getTapCount(outputSampleRate, passFrequency, passFrequency + 1500, attenuation);
        if (taps % 2 == 0) {
            ++taps;
        }
        float[] frequencyResponse = FilterFactory.getCICResponseArray(outputSampleRate, passFrequency, taps);
        FloatFFT_1D idft = new FloatFFT_1D((long)taps);
        idft.realInverseFull(frequencyResponse, false);
        float[] coefficients = new float[taps];
        int middleCoefficient = taps / 2;
        coefficients[middleCoefficient] = frequencyResponse[0];
        for (int x = 1; x <= middleCoefficient; ++x) {
            coefficients[middleCoefficient + x] = frequencyResponse[2 * x];
            coefficients[middleCoefficient - x] = frequencyResponse[2 * x];
        }
        FilterFactory.normalize(coefficients);
        return coefficients;
    }

    public static float[] getCICResponseArray(int sampleRate, int frequency, int length) {
        float[] cicArray = new float[length * 2];
        int binCount = (int)FastMath.round((double)((double)frequency / (double)sampleRate * 2.0 * (double)length));
        cicArray[0] = 1.0f;
        float unityResponse = (float)(FastMath.sin((double)(1.0 / (double)length)) / (1.0 / (double)length));
        for (int x = 1; x <= binCount; ++x) {
            float compensated;
            cicArray[x] = compensated = 1.0f + (unityResponse - (float)(FastMath.sin((double)((double)x / (double)length)) / ((double)x / (double)length)));
            cicArray[length - x] = compensated;
        }
        return cicArray;
    }

    public static float[] getRootRaisedCosine(double samplesPerSymbol, int symbolCount, float alpha) {
        int x;
        int taps = (int)(samplesPerSymbol * (double)symbolCount);
        float scale = 0.0f;
        float[] coefficients = new float[taps];
        for (x = 0; x < taps; ++x) {
            float denominator;
            float numerator;
            float index = (float)x - (float)taps / 2.0f;
            float x1 = (float)Math.PI * index / (float)samplesPerSymbol;
            float x2 = 4.0f * alpha * index / (float)samplesPerSymbol;
            float x3 = x2 * x2 - 1.0f;
            if ((double)FastMath.abs((float)x3) >= 1.0E-6) {
                numerator = x != taps / 2 ? (float)FastMath.cos((double)((1.0 + (double)alpha) * (double)x1)) + (float)FastMath.sin((double)((1.0f - alpha) * x1)) / (4.0f * alpha * index / (float)samplesPerSymbol) : (float)FastMath.cos((double)((1.0f + alpha) * x1)) + (1.0f - alpha) * (float)Math.PI / (4.0f * alpha);
                denominator = x3 * (float)Math.PI;
            } else {
                if (alpha == 1.0f) {
                    coefficients[x] = -1.0f;
                    continue;
                }
                x3 = (1.0f - alpha) * x1;
                x2 = (1.0f + alpha) * x1;
                numerator = (float)(FastMath.sin((double)x2) * (double)(1.0f + alpha) * Math.PI - FastMath.cos((double)x3) * ((1.0 - (double)alpha) * Math.PI * samplesPerSymbol) / (4.0 * (double)alpha * (double)index) + FastMath.sin((double)x3) * samplesPerSymbol * samplesPerSymbol / (4.0 * (double)alpha * (double)index * (double)index));
                denominator = (float)(-100.53096491487338 * (double)alpha * (double)alpha * (double)index / samplesPerSymbol);
            }
            coefficients[x] = 4.0f * alpha * numerator / denominator;
            scale += coefficients[x];
        }
        for (x = 0; x < taps; ++x) {
            coefficients[x] = coefficients[x] / scale;
        }
        return coefficients;
    }

    public static float[] getTaps(FIRFilterSpecification specification) throws FilterDesignException {
        RemezFIRFilterDesigner designer = new RemezFIRFilterDesigner(specification);
        if (designer.isValid()) {
            return designer.getImpulseResponse();
        }
        return null;
    }

    public static double evaluate(float[] filter, double frequency) {
        double real = 0.0;
        double imag = 0.0;
        for (int x = 0; x < filter.length; ++x) {
            real += (double)filter[x] * FastMath.cos((double)(Math.PI * frequency * (double)x));
            imag += (double)filter[x] * FastMath.sin((double)(Math.PI * frequency * (double)x));
        }
        return FilterFactory.decibel(real, imag);
    }

    public static double decibel(double real, double imag) {
        return (float)(10.0 * FastMath.log10((double)(FastMath.pow((double)real, (double)2.0) + FastMath.pow((double)imag, (double)2.0))));
    }

    public static float[] getRemezChannelizer(int channelBandwidth, int channels, int tapsPerChannel, double alpha, double passRipple, double stopRipple) throws FilterDesignException {
        FIRFilterSpecification specification = FIRFilterSpecification.channelizerBuilder().sampleRate(channels * channelBandwidth * 4).channels(channels).channelBandwidth(channelBandwidth).tapsPerChannel(tapsPerChannel).alpha(alpha).passRipple(passRipple).stopRipple(stopRipple).build();
        RemezFIRFilterDesignerWithLagrange designer = new RemezFIRFilterDesignerWithLagrange(specification);
        float[] taps = designer.getImpulseResponse();
        double bandEdgeFrequency = (double)channelBandwidth / (double)(channels * channelBandwidth * 2);
        double response = FilterFactory.decibel(designer.getFrequencyResponse(FastMath.cos((double)(bandEdgeFrequency * Math.PI))), 0.0);
        mLog.debug("Frequency Response at 1.0: " + response);
        response = FilterFactory.decibel(designer.getFrequencyResponse(FastMath.cos((double)(bandEdgeFrequency * Math.PI * 2.0))), 0.0);
        mLog.debug("Frequency Response at 2.0: " + response);
        return taps;
    }

    public static float[] getSincM2Synthesizer(double channelSampleRate, double channelBandwidth, int channels, int tapsPerChannel) throws FilterDesignException {
        int filterLength = channels * tapsPerChannel - 1;
        double cutoff = channelBandwidth * 1.1 / (channelSampleRate * (double)channels);
        float[] taps = FilterFactory.getKaiserSinc(filterLength, cutoff, 80.0f);
        float[] extendedTaps = new float[taps.length + 1];
        System.arraycopy(taps, 0, extendedTaps, 1, taps.length);
        return extendedTaps;
    }

    public static float[] getSincM2Channelizer(double channelBandwidth, int channels, int tapsPerChannel, boolean logResults) throws FilterDesignException {
        int currentTapsPerChannel = tapsPerChannel;
        int filterLength = channels * currentTapsPerChannel - 1;
        double sampleRate = channelBandwidth * (double)channels;
        double bandEdge = channelBandwidth / sampleRate;
        double cutoffFrequency = bandEdge / 2.0;
        double increment = cutoffFrequency * 0.1;
        float[] taps = null;
        taps = FilterFactory.getKaiserSinc(filterLength, cutoffFrequency, 80.0f);
        double response = FilterFactory.evaluate(taps, bandEdge);
        double incrementThreshold = 1.0 / sampleRate;
        while (increment > incrementThreshold) {
            if (FilterFactory.matchesObjective(response, -6.0206f, 3.0E-4) && cutoffFrequency + increment <= bandEdge) {
                float[] higherCutoffTaps = FilterFactory.getKaiserSinc(filterLength, cutoffFrequency + increment, 80.0f);
                double higherCutoffResponse = FilterFactory.evaluate(higherCutoffTaps, bandEdge);
                if (FilterFactory.matchesObjective(higherCutoffResponse, -6.0206f, 3.0E-4)) {
                    cutoffFrequency += increment;
                    taps = higherCutoffTaps;
                    response = higherCutoffResponse;
                    continue;
                }
                increment /= 2.0;
                continue;
            }
            if (FilterFactory.matchesObjective(response, -6.0206f, 3.0E-4)) {
                increment /= 2.0;
                continue;
            }
            if ((cutoffFrequency -= increment) <= 0.0) {
                if (logResults) {
                    mLog.debug("Warning: cannot design channelizer filter with tap count [" + currentTapsPerChannel + "] increasing tap count and starting over");
                }
                if (++currentTapsPerChannel > tapsPerChannel + 10) {
                    throw new FilterDesignException("Couldn't design filter with taps per channel count in the range of " + tapsPerChannel + " - " + (tapsPerChannel + 10) + " Sample Rate:" + sampleRate + " Channels:" + channels);
                }
                filterLength = channels * currentTapsPerChannel - 1;
                cutoffFrequency = channelBandwidth / sampleRate;
                increment = cutoffFrequency * 0.1;
            }
            taps = FilterFactory.getKaiserSinc(filterLength, cutoffFrequency, 80.0f);
            response = FilterFactory.evaluate(taps, bandEdge);
        }
        if (!FilterFactory.matchesObjective(response, -6.0206f, 3.0E-4)) {
            throw new FilterDesignException("Cannot design filter to specifications");
        }
        float[] extendedTaps = new float[taps.length + 1];
        System.arraycopy(taps, 0, extendedTaps, 1, taps.length);
        if (logResults) {
            mLog.debug("Polyphase Channelizer Filter Design Summary");
            mLog.debug("-----------------------------------------------------");
            mLog.debug("Input Sample Rate: " + sampleRate);
            mLog.debug("Channel Bandwidth: " + channelBandwidth);
            mLog.debug("Channels: " + channels);
            mLog.debug("Window Type: " + WindowType.KAISER.name());
            mLog.debug("Taps Per Channel - Requested:" + tapsPerChannel + " Actual:" + (double)extendedTaps.length / (double)channels);
            mLog.debug("Filter Length: " + extendedTaps.length);
            mLog.debug("Requested Cutoff Frequency:  " + sampleRate * bandEdge);
            mLog.debug("Actual Cutoff Frequency:  " + sampleRate * cutoffFrequency);
            mLog.debug("Attenuation at 0.25 Channels:  " + FilterFactory.evaluate(taps, bandEdge * 0.25) + "\tFrequency: " + sampleRate * bandEdge * 0.25 + "  [" + bandEdge * 0.25 + "]");
            mLog.debug("Attenuation at 0.50 Channels:  " + FilterFactory.evaluate(taps, bandEdge * 0.5) + "\tFrequency: " + sampleRate * bandEdge * 0.5 + "  [" + bandEdge * 0.5 + "]");
            mLog.debug("Attenuation at 0.75 Channels:  " + FilterFactory.evaluate(taps, bandEdge * 0.75) + "\tFrequency: " + sampleRate * bandEdge * 0.75 + "  [" + bandEdge * 0.75 + "]");
            mLog.debug("Attenuation        OBJECTIVE:  -6.020599842071533");
            mLog.debug("Attenuation at 1.00 Channels:  " + FilterFactory.evaluate(taps, bandEdge * 1.0) + "\tFrequency: " + sampleRate * bandEdge * 1.0 + "  [" + bandEdge * 1.0 + "]");
            mLog.debug("Attenuation at 1.25 Channels:  " + FilterFactory.evaluate(taps, bandEdge * 1.25) + "\tFrequency: " + sampleRate * bandEdge * 1.25 + "  [" + bandEdge * 1.25 + "]");
            mLog.debug("Attenuation at 1.50 Channels:  " + FilterFactory.evaluate(taps, bandEdge * 1.5) + "\tFrequency: " + sampleRate * bandEdge * 1.5 + "  [" + bandEdge * 1.5 + "]");
            mLog.debug("Attenuation at 1.75 Channels:  " + FilterFactory.evaluate(taps, bandEdge * 1.75) + "\tFrequency: " + sampleRate * bandEdge * 1.75 + "  [" + bandEdge * 1.75 + "]");
            mLog.debug("Attenuation at 2.00 Channels:  " + FilterFactory.evaluate(taps, bandEdge * 2.0) + "\tFrequency: " + sampleRate * bandEdge * 2.0 + "  [" + bandEdge * 2.0 + "]");
        }
        return extendedTaps;
    }

    public static float[] getSinc(double cutoff, int length, WindowType windowType) throws FilterDesignException {
        if (length % 2 == 0) {
            throw new FilterDesignException("Sinc filters must be odd-length");
        }
        float[] coefficients = new float[length];
        int half = length / 2;
        float[] window = WindowFactory.getWindow(windowType, length);
        double scalor = 2.0 * cutoff;
        double piScalor = Math.PI * scalor;
        coefficients[half] = (float)(1.0 * scalor * (double)window[half]);
        for (int x = 1; x <= half; ++x) {
            double a = piScalor * (double)x;
            double coefficient = scalor * FastMath.sin((double)a) / a;
            coefficients[half + x] = (float)(coefficient *= (double)window[half + x]);
            coefficients[half - x] = (float)coefficient;
        }
        return coefficients;
    }

    public static float[] getKaiserSinc(int length, double cutoff, float attenuation) throws FilterDesignException {
        if (length % 2 == 0) {
            throw new FilterDesignException("Sinc filters must be odd-length");
        }
        float[] coefficients = new float[length];
        int half = length / 2;
        float[] window = WindowFactory.getKaiser(length, attenuation);
        double scalor = 2.0 * cutoff;
        double piScalor = Math.PI * scalor;
        coefficients[half] = (float)(1.0 * scalor * (double)window[half]);
        for (int x = 1; x <= half; ++x) {
            double a = piScalor * (double)x;
            double coefficient = scalor * FastMath.sin((double)a) / a;
            coefficients[half + x] = (float)(coefficient *= (double)window[half + x]);
            coefficients[half - x] = (float)coefficient;
        }
        return coefficients;
    }

    public static float[] getHalfBand(int length, WindowType windowType) {
        if ((length - 3) % 4 != 0) {
            throw new IllegalArgumentException("Half Band filter length (N) must be an odd length where m must be an integer multiple in (N=4m+3), e.g. 7, 11, 15, etc");
        }
        float[] window = WindowFactory.getWindow(windowType, length);
        float[] taps = new float[length];
        int halfLength = length / 2;
        for (int x = 0; x < length; ++x) {
            int offset = x - halfLength;
            if (offset == 0) {
                taps[x] = 0.5f;
                continue;
            }
            if (x % 2 != 0) continue;
            taps[x] = (float)(Math.sin((double)offset * Math.PI / 2.0) / ((double)offset * Math.PI) * (double)window[x]);
        }
        return taps;
    }

    public static IRealFilter getRealFilter(float[] coefficients) {
        Implementation implementation = CalibrationManager.getInstance().getImplementation(CalibrationType.FILTER_FIR);
        switch (implementation) {
            case VECTOR_SIMD_PREFERRED: {
                return new VectorRealFIRFilterDefaultBit(coefficients);
            }
            case VECTOR_SIMD_64: {
                return new VectorRealFIRFilter64Bit(coefficients);
            }
            case VECTOR_SIMD_128: {
                return new VectorRealFIRFilter128Bit(coefficients);
            }
            case VECTOR_SIMD_256: {
                return new VectorRealFIRFilter256Bit(coefficients);
            }
            case VECTOR_SIMD_512: {
                return new VectorRealFIRFilter512Bit(coefficients);
            }
        }
        return new RealFIRFilter(coefficients);
    }

    public static IRealDecimationFilter getRealDecimationFilter(int length, WindowType windowType) {
        float[] coefficients = FilterFactory.getHalfBand(length, windowType);
        switch (length) {
            case 11: {
                switch (CalibrationManager.getInstance().getImplementation(CalibrationType.FILTER_HALF_BAND_REAL_11_TAP)) {
                    case VECTOR_SIMD_64: {
                        return new VectorRealHalfBandDecimationFilter11Tap64Bit(coefficients);
                    }
                    case VECTOR_SIMD_128: {
                        return new VectorRealHalfBandDecimationFilter11Tap128Bit(coefficients);
                    }
                    case VECTOR_SIMD_256: {
                        return new VectorRealHalfBandDecimationFilter11Tap256Bit(coefficients);
                    }
                    case VECTOR_SIMD_512: {
                        return new VectorRealHalfBandDecimationFilter11Tap512Bit(coefficients);
                    }
                }
                return new RealHalfBandDecimationFilter(coefficients);
            }
            case 15: {
                switch (CalibrationManager.getInstance().getImplementation(CalibrationType.FILTER_HALF_BAND_REAL_15_TAP)) {
                    case VECTOR_SIMD_64: {
                        return new VectorRealHalfBandDecimationFilter15Tap64Bit(coefficients);
                    }
                    case VECTOR_SIMD_128: {
                        return new VectorRealHalfBandDecimationFilter15Tap128Bit(coefficients);
                    }
                    case VECTOR_SIMD_256: {
                        return new VectorRealHalfBandDecimationFilter15Tap256Bit(coefficients);
                    }
                    case VECTOR_SIMD_512: {
                        return new VectorRealHalfBandDecimationFilter15Tap512Bit(coefficients);
                    }
                }
                return new RealHalfBandDecimationFilter(coefficients);
            }
            case 23: {
                switch (CalibrationManager.getInstance().getImplementation(CalibrationType.FILTER_HALF_BAND_REAL_23_TAP)) {
                    case VECTOR_SIMD_64: {
                        return new VectorRealHalfBandDecimationFilter23Tap64Bit(coefficients);
                    }
                    case VECTOR_SIMD_128: {
                        return new VectorRealHalfBandDecimationFilter23Tap128Bit(coefficients);
                    }
                    case VECTOR_SIMD_256: {
                        return new VectorRealHalfBandDecimationFilter23Tap256Bit(coefficients);
                    }
                    case VECTOR_SIMD_512: {
                        return new VectorRealHalfBandDecimationFilter23Tap512Bit(coefficients);
                    }
                }
                return new RealHalfBandDecimationFilter(coefficients);
            }
            case 63: {
                switch (CalibrationManager.getInstance().getImplementation(CalibrationType.FILTER_HALF_BAND_REAL_63_TAP)) {
                    case VECTOR_SIMD_64: {
                        return new VectorRealHalfBandDecimationFilter63Tap64Bit(coefficients);
                    }
                    case VECTOR_SIMD_128: {
                        return new VectorRealHalfBandDecimationFilter63Tap128Bit(coefficients);
                    }
                    case VECTOR_SIMD_256: {
                        return new VectorRealHalfBandDecimationFilter63Tap256Bit(coefficients);
                    }
                    case VECTOR_SIMD_512: {
                        return new VectorRealHalfBandDecimationFilter63Tap512Bit(coefficients);
                    }
                }
                return new RealHalfBandDecimationFilter(coefficients);
            }
        }
        switch (CalibrationManager.getInstance().getImplementation(CalibrationType.FILTER_HALF_BAND_REAL_DEFAULT)) {
            case VECTOR_SIMD_64: {
                return new VectorRealHalfBandDecimationFilter64Bit(coefficients);
            }
            case VECTOR_SIMD_128: {
                return new VectorRealHalfBandDecimationFilter128Bit(coefficients);
            }
            case VECTOR_SIMD_256: {
                return new VectorRealHalfBandDecimationFilter256Bit(coefficients);
            }
            case VECTOR_SIMD_512: {
                return new VectorRealHalfBandDecimationFilter512Bit(coefficients);
            }
        }
        return new RealHalfBandDecimationFilter(coefficients);
    }

    private static boolean matchesObjective(double a, double objective, double marginOfError) {
        return FastMath.abs((double)(a - objective)) <= marginOfError;
    }

    public static void main(String[] args) {
        DecimalFormat df = new DecimalFormat("0.000000");
        int length = 15;
        float[] taps = FilterFactory.getHalfBand(length, WindowType.HAMMING);
        for (int x = 0; x < length; ++x) {
            mLog.debug("Tap: " + x + " Value: " + df.format(taps[x]));
        }
        mLog.debug("Done!");
    }
}

