/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp.afsk;

import io.github.dsheirer.bits.IBinarySymbolProcessor;
import io.github.dsheirer.buffer.FloatAveragingBuffer;
import io.github.dsheirer.dsp.afsk.AFSKSampleBuffer;
import io.github.dsheirer.dsp.afsk.AFSKTimingErrorDetector;
import io.github.dsheirer.dsp.filter.resample.RealResampler;
import io.github.dsheirer.dsp.oscillator.IRealOscillator;
import io.github.dsheirer.dsp.oscillator.OscillatorFactory;
import io.github.dsheirer.sample.Listener;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AFSK1200Decoder
implements Listener<float[]> {
    private static final Logger mLog = LoggerFactory.getLogger(AFSK1200Decoder.class);
    public static final double SAMPLE_RATE = 7200.0;
    public static final int SAMPLES_PER_SYMBOL = 6;
    public static final int CORRELATION_PERIOD = 8;
    public static final int AVERAGING_PERIOD = 7;
    public static final double MARK = 1200.0;
    public static final double SPACE = 1800.0;
    public static final float TIMING_ERROR_GAIN = 0.33333334f;
    private Correlator mCorrelatorMark = new Correlator(this, 7200.0, 1200.0, 7, 8);
    private Correlator mCorrelatorSpace = new Correlator(this, 7200.0, 1800.0, 7, 8);
    private float[] mCorrelationValuesMark;
    private float[] mCorrelationValuesSpace;
    protected boolean mNormalOutput;
    protected float mSymbolTimingGain = 0.33333334f;
    protected AFSKSampleBuffer mSampleBuffer;
    protected AFSKTimingErrorDetector mTimingErrorDetector = new AFSKTimingErrorDetector(6);
    protected IBinarySymbolProcessor mBinarySymbolProcessor;
    private boolean mSampleDecision;
    private RealResampler mResampler = new RealResampler(8000.0, 7200.0, 8192, 512);

    public AFSK1200Decoder(AFSKSampleBuffer sampleBuffer, AFSKTimingErrorDetector detector, Output output) {
        this.mTimingErrorDetector = detector;
        this.mSampleBuffer = sampleBuffer;
        this.mSampleBuffer.setTimingGain(this.mSymbolTimingGain);
        this.mResampler.setListener(new Decoder());
        this.mNormalOutput = output == Output.NORMAL;
    }

    public AFSK1200Decoder(Output output) {
        this(new AFSKSampleBuffer(6, 0.33333334f), new AFSKTimingErrorDetector(6), output);
    }

    public void dispose() {
    }

    @Override
    public void receive(float[] buffer) {
        this.mResampler.resample(buffer);
    }

    protected void dispatch(boolean symbol) {
        if (this.mBinarySymbolProcessor != null) {
            this.mBinarySymbolProcessor.process(this.mNormalOutput ? symbol : !symbol);
        }
    }

    public void setSymbolProcessor(IBinarySymbolProcessor binarySymbolProcessor) {
        this.mBinarySymbolProcessor = binarySymbolProcessor;
    }

    public void removeListener() {
        this.mBinarySymbolProcessor = null;
    }

    public class Correlator {
        private FloatAveragingBuffer mAveragingBuffer;
        private float[] mReferenceSamples;
        private float[] mDemodulatedSamples;
        private float[] mCorrelationValues;
        private float mCorrelationAccumulator;

        public Correlator(AFSK1200Decoder this$0, double sampleRate, double frequency, int averagingPeriod, int correlationPeriod) {
            this.mAveragingBuffer = new FloatAveragingBuffer(averagingPeriod);
            IRealOscillator referenceSignalGenerator = OscillatorFactory.getRealOscillator(frequency, sampleRate);
            this.mReferenceSamples = referenceSignalGenerator.generate(correlationPeriod);
            this.mDemodulatedSamples = new float[correlationPeriod];
        }

        public float[] process(float[] samples) {
            if (this.mCorrelationValues == null || this.mCorrelationValues.length != samples.length) {
                this.mCorrelationValues = new float[samples.length];
            }
            for (int x = 0; x < samples.length; ++x) {
                System.arraycopy(this.mDemodulatedSamples, 1, this.mDemodulatedSamples, 0, this.mDemodulatedSamples.length - 1);
                this.mDemodulatedSamples[this.mDemodulatedSamples.length - 1] = samples[x];
                this.mCorrelationAccumulator = 0.0f;
                for (int y = 0; y < this.mDemodulatedSamples.length; ++y) {
                    this.mCorrelationAccumulator += this.mDemodulatedSamples[y] * this.mReferenceSamples[y];
                }
                this.mCorrelationValues[x] = this.mAveragingBuffer.get(FastMath.abs((float)this.mCorrelationAccumulator));
            }
            return this.mCorrelationValues;
        }
    }

    public class Decoder
    implements Listener<float[]> {
        @Override
        public void receive(float[] buffer) {
            AFSK1200Decoder.this.mCorrelationValuesMark = AFSK1200Decoder.this.mCorrelatorMark.process(buffer);
            AFSK1200Decoder.this.mCorrelationValuesSpace = AFSK1200Decoder.this.mCorrelatorSpace.process(buffer);
            for (int x = 0; x < AFSK1200Decoder.this.mCorrelationValuesMark.length; ++x) {
                AFSK1200Decoder.this.mSampleDecision = AFSK1200Decoder.this.mCorrelationValuesMark[x] > AFSK1200Decoder.this.mCorrelationValuesSpace[x];
                AFSK1200Decoder.this.mSampleBuffer.receive(AFSK1200Decoder.this.mSampleDecision);
                AFSK1200Decoder.this.mTimingErrorDetector.receive(AFSK1200Decoder.this.mSampleDecision);
                if (!AFSK1200Decoder.this.mSampleBuffer.hasSymbol()) continue;
                AFSK1200Decoder.this.dispatch(AFSK1200Decoder.this.mSampleBuffer.getSymbol());
                AFSK1200Decoder.this.mSampleBuffer.resetAndAdjust(AFSK1200Decoder.this.mTimingErrorDetector.getError());
            }
        }
    }

    public static enum Output {
        NORMAL,
        INVERTED;

    }
}

