/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.dsp;

import io.github.dsheirer.bits.IBinarySymbolProcessor;
import io.github.dsheirer.sample.Listener;

public class NRZDecoder
implements IBinarySymbolProcessor {
    public static final boolean MODE_NORMAL = true;
    public static final boolean MODE_INVERTED = false;
    private IBinarySymbolProcessor mListener;
    private boolean mMode = true;
    private boolean mPrevious;

    public NRZDecoder(boolean mode) {
        this.mMode = mode;
    }

    public NRZDecoder() {
        this(true);
    }

    public void dispose() {
        this.mListener = null;
    }

    @Override
    public void process(boolean symbol) {
        boolean result = this.mPrevious ^ symbol;
        if (this.mListener != null) {
            this.mListener.process(this.mMode ? result : !result);
        }
        this.mPrevious = result;
    }

    public void setListener(IBinarySymbolProcessor listener) {
        this.mListener = listener;
    }

    public void removeListener(Listener<Boolean> listener) {
        this.mListener = null;
    }
}

