/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.controller.channel.map;

import io.github.dsheirer.controller.channel.map.ChannelRange;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.table.AbstractTableModel;

public class ChannelRangeModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final int START = 0;
    private static final int STOP = 1;
    private static final int BASE = 2;
    private static final int SIZE = 3;
    private static final int ERROR = 4;
    protected int[] mColumnWidths = new int[]{110, 110, 110, -1, 80};
    protected String[] mHeaders = new String[]{"Begin", "End", "Base", "Size", "Error"};
    private List<ChannelRange> mRanges = new CopyOnWriteArrayList<ChannelRange>();
    private ChannelRangeEventListener mListener;

    public void setListener(ChannelRangeEventListener listener) {
        this.mListener = listener;
    }

    private void broadcastChange() {
        if (this.mListener != null) {
            this.mListener.channelRangesChanged();
        }
    }

    public void clear() {
        for (ChannelRange range : this.mRanges) {
            this.removeRange(range);
        }
        this.broadcastChange();
    }

    public List<ChannelRange> getChannelRanges() {
        return this.mRanges;
    }

    public void addRanges(List<ChannelRange> ranges) {
        for (ChannelRange range : ranges) {
            this.addRange(range);
        }
        this.broadcastChange();
    }

    public void addRange(ChannelRange range) {
        if (range != null && !this.mRanges.contains(range)) {
            this.mRanges.add(range);
            int index = this.mRanges.indexOf(range);
            this.fireTableRowsInserted(index, index);
        }
        this.validate();
        this.broadcastChange();
    }

    public void removeRange(ChannelRange range) {
        if (range != null && this.mRanges.contains(range)) {
            int index = this.mRanges.indexOf(range);
            this.mRanges.remove(range);
            this.fireTableRowsDeleted(index, index);
        }
        this.validate();
        this.broadcastChange();
    }

    public int[] getColumnWidths() {
        return this.mColumnWidths;
    }

    public void setColumnWidths(int[] widths) {
        if (widths.length != this.mHeaders.length) {
            throw new IllegalArgumentException("ChannelMapRangeModel - column widths array should have " + this.mHeaders.length + " elements");
        }
        this.mColumnWidths = widths;
    }

    @Override
    public int getRowCount() {
        return this.mRanges.size();
    }

    @Override
    public int getColumnCount() {
        return this.mHeaders.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.mHeaders[column];
    }

    public ChannelRange getChannelRange(int index) {
        if (index < this.mRanges.size()) {
            return this.mRanges.get(index);
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ChannelRange range = this.getChannelRange(rowIndex);
        if (range != null) {
            switch (columnIndex) {
                case 0: {
                    return range.getFirstChannelNumber();
                }
                case 1: {
                    return range.getLastChannelNumber();
                }
                case 2: {
                    return range.getBaseFrequency();
                }
                case 3: {
                    return range.getStepSize();
                }
                case 4: {
                    StringBuilder sb = new StringBuilder();
                    if (!range.isValid()) {
                        sb.append("Sequence");
                    }
                    if (range.isOverlapping()) {
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append("Overlap");
                    }
                    return sb.toString();
                }
            }
        }
        return null;
    }

    private void validate() {
        int x;
        for (x = 0; x < this.mRanges.size(); ++x) {
            this.mRanges.get(x).setOverlapping(false);
            this.fireTableCellUpdated(x, 4);
        }
        for (x = 0; x < this.mRanges.size(); ++x) {
            for (int y = x + 1; y < this.mRanges.size(); ++y) {
                if (!this.mRanges.get(x).overlaps(this.mRanges.get(y))) continue;
                this.mRanges.get(x).setOverlapping(true);
                this.fireTableCellUpdated(x, 4);
                this.mRanges.get(y).setOverlapping(true);
                this.fireTableCellUpdated(y, 4);
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return row < this.mRanges.size() && column != 4;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        int parsedValue = -1;
        try {
            parsedValue = Integer.parseInt((String)value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (parsedValue >= 0) {
            ChannelRange range = this.getChannelRange(row);
            if (range != null) {
                switch (column) {
                    case 0: {
                        range.setFirstChannelNumber(parsedValue);
                        break;
                    }
                    case 1: {
                        range.setLastChannelNumber(parsedValue);
                        break;
                    }
                    case 2: {
                        range.setBaseFrequency(parsedValue);
                        break;
                    }
                    case 3: {
                        range.setStepSize(parsedValue);
                    }
                }
                this.validate();
                this.broadcastChange();
            } else {
                throw new IllegalArgumentException("Invalid channel range row index");
            }
        }
    }

    public static interface ChannelRangeEventListener {
        public void channelRangesChanged();
    }
}

