/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.controller.channel;

import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelEvent;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class ChannelModel
implements Listener<ChannelEvent> {
    private ObservableList<Channel> mChannels = FXCollections.observableArrayList(Channel.extractor());
    private ObservableList<Channel> mTrafficChannels = FXCollections.observableArrayList(Channel.extractor());
    private Broadcaster<ChannelEvent> mChannelEventBroadcaster = new Broadcaster();
    private AliasModel mAliasModel;

    public ChannelModel(AliasModel aliasModel) {
        this.mAliasModel = aliasModel;
        ChannelListChangeListener changeListener = new ChannelListChangeListener();
        this.mChannels.addListener((ListChangeListener)changeListener);
        this.mTrafficChannels.addListener((ListChangeListener)changeListener);
    }

    public ObservableList<Channel> channelList() {
        return this.mChannels;
    }

    public ObservableList<Channel> trafficChannelList() {
        return this.mTrafficChannels;
    }

    public void clear() {
        ArrayList<Channel> trafficChannels = new ArrayList<Channel>((Collection<Channel>)this.mTrafficChannels);
        for (Channel trafficChannel : trafficChannels) {
            this.removeChannel(trafficChannel);
        }
        ArrayList<Channel> channels = new ArrayList<Channel>((Collection<Channel>)this.mChannels);
        for (Channel channel : channels) {
            this.removeChannel(channel);
        }
    }

    public List<Channel> getChannels() {
        return Collections.unmodifiableList(this.mChannels);
    }

    public Channel getChannelAtIndex(int row) {
        if (row < this.mChannels.size()) {
            return (Channel)this.mChannels.get(row);
        }
        return null;
    }

    public List<String> getSystemNames() {
        ArrayList<String> systems = new ArrayList<String>();
        for (Channel channel : this.mChannels) {
            if (!channel.hasSystem() || systems.contains(channel.getSystem())) continue;
            systems.add(channel.getSystem());
        }
        Collections.sort(systems);
        return systems;
    }

    @Override
    public void receive(ChannelEvent event) {
        if (event.getChannel().getChannelType() == Channel.ChannelType.STANDARD) {
            switch (event.getEvent()) {
                case NOTIFICATION_CONFIGURATION_CHANGE: 
                case NOTIFICATION_SELECTION_CHANGE: {
                    this.mChannelEventBroadcaster.broadcast(event);
                    break;
                }
            }
        }
        if (event.getEvent() == ChannelEvent.Event.REQUEST_DELETE) {
            this.removeChannel(event.getChannel());
        }
    }

    public void addChannels(List<Channel> channels) {
        for (Channel channel : channels) {
            this.addChannel(channel);
        }
    }

    public void addChannel(Channel channel) {
        switch (channel.getChannelType()) {
            case STANDARD: {
                this.mChannels.add((Object)channel);
                this.mAliasModel.addAliasList(channel.getAliasListName());
                break;
            }
            case TRAFFIC: {
                this.mTrafficChannels.add((Object)channel);
                break;
            }
        }
    }

    public void removeChannel(Channel channel) {
        if (channel != null) {
            switch (channel.getChannelType()) {
                case STANDARD: {
                    this.mChannels.remove((Object)channel);
                    break;
                }
                case TRAFFIC: {
                    this.mTrafficChannels.remove((Object)channel);
                    break;
                }
            }
        }
    }

    public List<Channel> getAutoStartChannels() {
        ArrayList<Channel> autoStartChannels = new ArrayList<Channel>();
        for (Channel channel : this.getChannels()) {
            if (!channel.isAutoStart()) continue;
            autoStartChannels.add(channel);
        }
        autoStartChannels.sort((channel1, channel2) -> {
            if (channel1.hasAutoStartOrder() && channel2.hasAutoStartOrder()) {
                return Integer.compare(channel1.getAutoStartOrder(), channel2.getAutoStartOrder());
            }
            if (channel1.hasAutoStartOrder()) {
                return -1;
            }
            if (channel2.hasAutoStartOrder()) {
                return 1;
            }
            return 0;
        });
        return autoStartChannels;
    }

    public List<Channel> getChannelsInFrequencyRange(long start, long stop) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (Channel channel : this.mChannels) {
            if (!channel.isWithin(start, stop)) continue;
            channels.add(channel);
        }
        for (Channel channel : this.mTrafficChannels) {
            if (!channel.isWithin(start, stop)) continue;
            channels.add(channel);
        }
        return channels;
    }

    public void addListener(Listener<ChannelEvent> listener) {
        this.mChannelEventBroadcaster.addListener(listener);
    }

    public void removeListener(Listener<ChannelEvent> listener) {
        this.mChannelEventBroadcaster.removeListener(listener);
    }

    public List<String> getSiteNames() {
        ArrayList<String> sites = new ArrayList<String>();
        for (Channel channel : this.mChannels) {
            String site = channel.getSite();
            if (site == null || site.isEmpty() || sites.contains(site)) continue;
            sites.add(site);
        }
        return sites;
    }

    public class ChannelListChangeListener
    implements ListChangeListener<Channel> {
        public void onChanged(ListChangeListener.Change<? extends Channel> change) {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (Channel channel : change.getAddedSubList()) {
                        ChannelModel.this.mChannelEventBroadcaster.broadcast(new ChannelEvent(channel, ChannelEvent.Event.NOTIFICATION_ADD));
                    }
                    continue;
                }
                if (change.wasRemoved()) {
                    for (Channel channel : change.getRemoved()) {
                        ChannelModel.this.mChannelEventBroadcaster.broadcast(new ChannelEvent(channel, ChannelEvent.Event.NOTIFICATION_DELETE));
                    }
                    continue;
                }
                if (!change.wasUpdated()) continue;
                for (int x = change.getFrom(); x < change.getTo(); ++x) {
                    ChannelModel.this.mChannelEventBroadcaster.broadcast(new ChannelEvent((Channel)change.getList().get(x), ChannelEvent.Event.NOTIFICATION_CONFIGURATION_CHANGE));
                }
            }
        }
    }
}

