/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.controller.channel;

import io.github.dsheirer.controller.channel.Channel;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class AutoStartChannelModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final int COLUMN_ORDER = 0;
    public static final int COLUMN_SYSTEM = 1;
    public static final int COLUMN_SITE = 2;
    public static final int COLUMN_NAME = 3;
    public static final int COLUMN_DECODER = 4;
    private static final String[] COLUMN_NAMES = new String[]{"Order", "System", "Site", "Name", "Decoder"};
    private List<Channel> mChannels;

    public AutoStartChannelModel(List<Channel> autoStartChannels) {
        this.mChannels = autoStartChannels;
    }

    @Override
    public int getRowCount() {
        return this.mChannels.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < COLUMN_NAMES.length) {
            return COLUMN_NAMES[columnIndex];
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Channel channel = this.mChannels.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return channel.getAutoStartOrder();
            }
            case 1: {
                return channel.getSystem();
            }
            case 2: {
                return channel.getSite();
            }
            case 3: {
                return channel.getName();
            }
            case 4: {
                return channel.getDecodeConfiguration().getDecoderType().getShortDisplayString();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new IllegalArgumentException("Not yet implemented");
    }
}

