/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.controller;

import com.jidesoft.swing.JideTabbedPane;
import io.github.dsheirer.audio.playback.AudioPanel;
import io.github.dsheirer.audio.playback.AudioPlaybackManager;
import io.github.dsheirer.channel.metadata.NowPlayingPanel;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.gui.playlist.ViewPlaylistRequest;
import io.github.dsheirer.icon.IconModel;
import io.github.dsheirer.map.MapPanel;
import io.github.dsheirer.map.MapService;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.settings.SettingsManager;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.ui.TunerViewPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jiconfont.IconCode;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerPanel
extends JPanel {
    private static final Logger mLog = LoggerFactory.getLogger(ControllerPanel.class);
    private static final long serialVersionUID = 1L;
    private int mSettingsTabIndex = -1;
    private AudioPanel mAudioPanel;
    private NowPlayingPanel mNowPlayingPanel;
    private MapPanel mMapPanel;
    private TunerViewPanel mTunerManagerPanel;
    private JideTabbedPane mTabbedPane;

    public ControllerPanel(PlaylistManager playlistManager, AudioPlaybackManager audioPlaybackManager, IconModel iconModel, MapService mapService, SettingsManager settingsManager, TunerManager tunerManager, UserPreferences userPreferences, boolean detailTabsVisible) {
        this.mAudioPanel = new AudioPanel(iconModel, userPreferences, settingsManager, audioPlaybackManager, playlistManager.getAliasModel());
        this.mNowPlayingPanel = new NowPlayingPanel(playlistManager, iconModel, userPreferences, settingsManager, detailTabsVisible);
        this.mMapPanel = new MapPanel(mapService, playlistManager.getAliasModel(), iconModel, settingsManager);
        this.mTunerManagerPanel = new TunerViewPanel(tunerManager, userPreferences);
        this.init();
    }

    public NowPlayingPanel getNowPlayingPanel() {
        return this.mNowPlayingPanel;
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0 ", "[grow,fill]", "[]0[grow,fill]0[]"));
        this.add((Component)this.mAudioPanel, "wrap");
        this.mTabbedPane = new JideTabbedPane(){

            public void setSelectedIndex(int index) {
                if (index == ControllerPanel.this.mSettingsTabIndex) {
                    MyEventBus.getGlobalEventBus().post((Object)new ViewPlaylistRequest());
                } else {
                    super.setSelectedIndex(index);
                }
            }
        };
        this.mTabbedPane.setFont(this.getFont());
        this.mTabbedPane.setForeground(Color.BLACK);
        this.mTabbedPane.addTab("Now Playing", (Component)this.mNowPlayingPanel);
        this.mTabbedPane.addTab("Map", (Component)this.mMapPanel);
        this.mTabbedPane.addTab("Tuners", (Component)this.mTunerManagerPanel);
        Icon playIcon = IconFontSwing.buildIcon((IconCode)FontAwesome.PLAY_CIRCLE_O, (float)20.0f, (Color)Color.DARK_GRAY);
        this.mTabbedPane.addTab("Playlist Editor", playIcon, (Component)new JLabel("Show Playlist Manager"));
        this.mSettingsTabIndex = this.mTabbedPane.getTabCount() - 1;
        this.mTabbedPane.setPreferredSize(new Dimension(880, 500));
        this.add((Component)this.mTabbedPane, "wrap");
    }
}

