/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.channel.state;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.channel.state.DecoderState;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.IdentifierUpdateNotification;
import io.github.dsheirer.identifier.MutableIdentifierCollection;
import io.github.dsheirer.identifier.configuration.ChannelDescriptorConfigurationIdentifier;
import io.github.dsheirer.sample.Listener;

public abstract class TimeslotDecoderState
extends DecoderState {
    private int mTimeslot;

    public TimeslotDecoderState(int timeslot) {
        super(new MutableIdentifierCollection(timeslot));
        this.mTimeslot = timeslot;
        this.mConfigurationIdentifierListener = new TimeslotConfigurationIdentifierListener();
    }

    protected int getTimeslot() {
        return this.mTimeslot;
    }

    public class TimeslotConfigurationIdentifierListener
    implements Listener<IdentifierUpdateNotification> {
        @Override
        public void receive(IdentifierUpdateNotification identifierUpdateNotification) {
            if (identifierUpdateNotification.getTimeslot() == TimeslotDecoderState.this.getTimeslot()) {
                if (identifierUpdateNotification.getIdentifier().getIdentifierClass() == IdentifierClass.CONFIGURATION && identifierUpdateNotification.getIdentifier().getForm() != Form.DECODER_TYPE && identifierUpdateNotification.getIdentifier().getForm() != Form.CHANNEL_DESCRIPTOR) {
                    if (identifierUpdateNotification.isAdd()) {
                        TimeslotDecoderState.this.getIdentifierCollection().update(identifierUpdateNotification.getIdentifier());
                    } else if (identifierUpdateNotification.isSilentAdd()) {
                        TimeslotDecoderState.this.getIdentifierCollection().silentUpdate(identifierUpdateNotification.getIdentifier());
                    }
                }
                if (identifierUpdateNotification.getOperation() == IdentifierUpdateNotification.Operation.ADD) {
                    Identifier<?> identifier = identifierUpdateNotification.getIdentifier();
                    if (identifier instanceof ChannelDescriptorConfigurationIdentifier) {
                        TimeslotDecoderState.this.setCurrentChannel((IChannelDescriptor)((ChannelDescriptorConfigurationIdentifier)identifier).getValue());
                    } else if (identifier instanceof IChannelDescriptor) {
                        TimeslotDecoderState.this.setCurrentChannel((IChannelDescriptor)((Object)identifier));
                    }
                }
            }
        }
    }
}

