/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.channel.state;

import java.util.EnumSet;

public enum State {
    ACTIVE("ACTIVE"){

        @Override
        public boolean canChangeTo(State state) {
            return state == CALL || state == CONTROL || state == DATA || state == ENCRYPTED || state == FADE || state == IDLE || state == TEARDOWN || state == RESET;
        }
    }
    ,
    CALL("CALL"){

        @Override
        public boolean canChangeTo(State state) {
            return state == ACTIVE || state == CONTROL || state == DATA || state == ENCRYPTED || state == FADE || state == IDLE || state == TEARDOWN || state == RESET;
        }
    }
    ,
    CONTROL("CONTROL"){

        @Override
        public boolean canChangeTo(State state) {
            return state == IDLE || state == FADE || state == RESET;
        }
    }
    ,
    DATA("DATA"){

        @Override
        public boolean canChangeTo(State state) {
            return state == ACTIVE || state == CALL || state == CONTROL || state == ENCRYPTED || state == FADE || state == RESET || state == TEARDOWN;
        }
    }
    ,
    ENCRYPTED("ENCRYPTED"){

        @Override
        public boolean canChangeTo(State state) {
            return state == FADE || state == TEARDOWN || state == RESET;
        }
    }
    ,
    FADE("FADE"){

        @Override
        public boolean canChangeTo(State state) {
            return state != FADE && state != RESET;
        }
    }
    ,
    IDLE("IDLE"){

        @Override
        public boolean canChangeTo(State state) {
            return state != TEARDOWN && state != RESET;
        }
    }
    ,
    RESET("RESET"){

        @Override
        public boolean canChangeTo(State state) {
            return state == IDLE;
        }
    }
    ,
    TEARDOWN("TEARDOWN"){

        @Override
        public boolean canChangeTo(State state) {
            return state == RESET;
        }
    };

    private String mDisplayValue;
    public static final EnumSet<State> SINGLE_CHANNEL_ACTIVE_STATES;
    public static final EnumSet<State> MULTI_CHANNEL_ACTIVE_STATES;

    private State(String displayValue) {
        this.mDisplayValue = displayValue;
    }

    public abstract boolean canChangeTo(State var1);

    public String getDisplayValue() {
        return this.mDisplayValue;
    }

    public String toString() {
        return this.mDisplayValue;
    }

    static {
        SINGLE_CHANNEL_ACTIVE_STATES = EnumSet.of(ACTIVE, CALL, CONTROL, DATA, ENCRYPTED);
        MULTI_CHANNEL_ACTIVE_STATES = EnumSet.of(ACTIVE, new State[]{CALL, CONTROL, DATA, ENCRYPTED, IDLE});
    }
}

