/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.channel.state;

import io.github.dsheirer.channel.state.State;

public class DecoderStateEvent {
    private Object mSource;
    private Event mEvent;
    private State mState;
    private int mTimeslot;
    private long mFrequency;

    public DecoderStateEvent(Object source, Event event, State state, int timeslot, long frequency) {
        this.mSource = source;
        this.mEvent = event;
        this.mState = state;
        this.mTimeslot = timeslot;
        this.mFrequency = frequency;
    }

    public DecoderStateEvent(Object source, Event event, State state, int timeslot) {
        this(source, event, state, timeslot, 0L);
    }

    public DecoderStateEvent(Object source, Event event, State state) {
        this(source, event, state, 0, 0L);
    }

    public DecoderStateEvent(Object source, Event event, State state, long frequency) {
        this(source, event, state, 0, frequency);
    }

    public static DecoderStateEvent stateNotification(State state, int timeslot) {
        return new DecoderStateEvent((Object)null, Event.NOTIFICATION_CHANNEL_STATE, state, timeslot);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Decoder State Event - source[").append(this.mSource != null ? this.mSource.getClass() : "null").append("] event[").append((Object)this.mEvent).append("] state[").append((Object)this.mState).append("] timeslot[").append(this.mTimeslot).append("] frequency [").append(this.mFrequency).append("]");
        return sb.toString();
    }

    public Object getSource() {
        return this.mSource;
    }

    public Event getEvent() {
        return this.mEvent;
    }

    public State getState() {
        return this.mState;
    }

    public long getFrequency() {
        return this.mFrequency;
    }

    public int getTimeslot() {
        return this.mTimeslot;
    }

    public static enum Event {
        CONTINUATION,
        DECODE,
        END,
        START,
        NOTIFICATION_CHANNEL_STATE,
        NOTIFICATION_CHANNEL_ACTIVE_STATE,
        NOTIFICATION_CHANNEL_INACTIVE_STATE,
        NOTIFICATION_SOURCE_FREQUENCY,
        REQUEST_ALWAYS_UNSQUELCH,
        REQUEST_CHANGE_CALL_TIMEOUT,
        REQUEST_RESET,
        REQUEST_CONVERT_TO_TRAFFIC_CHANNEL;

    }
}

