/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer.airspy;

import io.github.dsheirer.buffer.AbstractNativeBuffer;
import io.github.dsheirer.buffer.airspy.AirspyBufferIteratorScalar;
import io.github.dsheirer.buffer.airspy.AirspyBufferIteratorVector128Bits;
import io.github.dsheirer.buffer.airspy.AirspyBufferIteratorVector256Bits;
import io.github.dsheirer.buffer.airspy.AirspyBufferIteratorVector512Bits;
import io.github.dsheirer.buffer.airspy.AirspyBufferIteratorVector64Bits;
import io.github.dsheirer.buffer.airspy.AirspyInterleavedBufferIteratorScalar;
import io.github.dsheirer.buffer.airspy.AirspyInterleavedBufferIteratorVector128Bits;
import io.github.dsheirer.buffer.airspy.AirspyInterleavedBufferIteratorVector256Bits;
import io.github.dsheirer.buffer.airspy.AirspyInterleavedBufferIteratorVector512Bits;
import io.github.dsheirer.buffer.airspy.AirspyInterleavedBufferIteratorVector64Bits;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.sample.complex.InterleavedComplexSamples;
import io.github.dsheirer.vector.calibrate.Implementation;
import java.util.Iterator;

public class AirspyNativeBuffer
extends AbstractNativeBuffer {
    private short[] mSamples;
    private short[] mResidualI;
    private short[] mResidualQ;
    private float mAverageDc;
    private Implementation mInterleavedImplementation;
    private Implementation mNonInterleavedImplementation;

    public AirspyNativeBuffer(short[] samples, short[] residualI, short[] residualQ, float averageDc, long timestamp, Implementation interleavedImplementation, Implementation nonInterleavedImplementation, float samplesPerMillisecond) {
        super(timestamp, samplesPerMillisecond);
        if (samples.length % 2048 != 0) {
            throw new IllegalArgumentException("Samples short[] length [" + samples.length + "] must be an even multiple of 2048");
        }
        this.mSamples = samples;
        this.mResidualI = residualI;
        this.mResidualQ = residualQ;
        this.mAverageDc = averageDc;
        this.mInterleavedImplementation = interleavedImplementation;
        this.mNonInterleavedImplementation = nonInterleavedImplementation;
    }

    @Override
    public int sampleCount() {
        return this.mSamples.length / 2;
    }

    @Override
    public Iterator<ComplexSamples> iterator() {
        return switch (this.mInterleavedImplementation) {
            case Implementation.VECTOR_SIMD_512 -> new AirspyBufferIteratorVector512Bits(this.mSamples, this.mResidualI, this.mResidualQ, this.mAverageDc, this.getTimestamp(), this.getSamplesPerMillisecond());
            case Implementation.VECTOR_SIMD_256 -> new AirspyBufferIteratorVector256Bits(this.mSamples, this.mResidualI, this.mResidualQ, this.mAverageDc, this.getTimestamp(), this.getSamplesPerMillisecond());
            case Implementation.VECTOR_SIMD_128 -> new AirspyBufferIteratorVector128Bits(this.mSamples, this.mResidualI, this.mResidualQ, this.mAverageDc, this.getTimestamp(), this.getSamplesPerMillisecond());
            case Implementation.VECTOR_SIMD_64 -> new AirspyBufferIteratorVector64Bits(this.mSamples, this.mResidualI, this.mResidualQ, this.mAverageDc, this.getTimestamp(), this.getSamplesPerMillisecond());
            default -> new AirspyBufferIteratorScalar(this.mSamples, this.mResidualI, this.mResidualQ, this.mAverageDc, this.getTimestamp(), this.getSamplesPerMillisecond());
        };
    }

    @Override
    public Iterator<InterleavedComplexSamples> iteratorInterleaved() {
        return switch (this.mInterleavedImplementation) {
            case Implementation.VECTOR_SIMD_512 -> new AirspyInterleavedBufferIteratorVector512Bits(this.mSamples, this.mResidualI, this.mResidualQ, this.mAverageDc, this.getTimestamp(), this.getSamplesPerMillisecond());
            case Implementation.VECTOR_SIMD_256 -> new AirspyInterleavedBufferIteratorVector256Bits(this.mSamples, this.mResidualI, this.mResidualQ, this.mAverageDc, this.getTimestamp(), this.getSamplesPerMillisecond());
            case Implementation.VECTOR_SIMD_128 -> new AirspyInterleavedBufferIteratorVector128Bits(this.mSamples, this.mResidualI, this.mResidualQ, this.mAverageDc, this.getTimestamp(), this.getSamplesPerMillisecond());
            case Implementation.VECTOR_SIMD_64 -> new AirspyInterleavedBufferIteratorVector64Bits(this.mSamples, this.mResidualI, this.mResidualQ, this.mAverageDc, this.getTimestamp(), this.getSamplesPerMillisecond());
            default -> new AirspyInterleavedBufferIteratorScalar(this.mSamples, this.mResidualI, this.mResidualQ, this.mAverageDc, this.getTimestamp(), this.getSamplesPerMillisecond());
        };
    }
}

