/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer.airspy;

import io.github.dsheirer.buffer.airspy.AirspyBufferIterator;
import io.github.dsheirer.sample.complex.InterleavedComplexSamples;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

public class AirspyInterleavedBufferIteratorVector64Bits
extends AirspyBufferIterator<InterleavedComplexSamples> {
    private static final VectorSpecies<Float> VECTOR_SPECIES = FloatVector.SPECIES_64;

    public AirspyInterleavedBufferIteratorVector64Bits(short[] samples, short[] residualI, short[] residualQ, float averageDc, long timestamp, float samplesPerMillisecond) {
        super(samples, residualI, residualQ, averageDc, timestamp, samplesPerMillisecond);
    }

    @Override
    public InterleavedComplexSamples next() {
        if (this.mSamplesPointer >= this.mSamples.length) {
            throw new IllegalStateException("End of buffer exceeded");
        }
        long timestamp = this.getFragmentTimestamp(this.mSamplesPointer);
        int offset = this.mSamplesPointer;
        int fragmentPointer = 0;
        float[] scaledSamples = new float[VECTOR_SPECIES.length()];
        while (fragmentPointer < 2048) {
            int y;
            for (y = 0; y < VECTOR_SPECIES.length(); ++y) {
                scaledSamples[y] = this.mSamples[offset++];
            }
            FloatVector.fromArray(VECTOR_SPECIES, (float[])scaledSamples, (int)0).sub(2048.0f).mul(4.8828125E-4f).sub(this.mAverageDc).intoArray(scaledSamples, 0);
            for (y = 0; y < VECTOR_SPECIES.length(); y += 2) {
                this.mIBuffer[fragmentPointer + 11] = scaledSamples[y];
                this.mQBuffer[fragmentPointer++ + 23] = scaledSamples[y + 1];
            }
        }
        this.mSamplesPointer = offset;
        float[] samples = new float[4096];
        FloatVector f1 = FloatVector.fromArray(VECTOR_SPECIES, (float[])COEFFICIENTS, (int)0);
        FloatVector f2 = FloatVector.fromArray(VECTOR_SPECIES, (float[])COEFFICIENTS, (int)2);
        FloatVector f3 = FloatVector.fromArray(VECTOR_SPECIES, (float[])COEFFICIENTS, (int)4);
        FloatVector f4 = FloatVector.fromArray(VECTOR_SPECIES, (float[])COEFFICIENTS, (int)6);
        FloatVector f5 = FloatVector.fromArray(VECTOR_SPECIES, (float[])COEFFICIENTS, (int)8);
        FloatVector f6 = FloatVector.fromArray(VECTOR_SPECIES, (float[])COEFFICIENTS, (int)10);
        FloatVector f7 = FloatVector.fromArray(VECTOR_SPECIES, (float[])COEFFICIENTS, (int)12);
        FloatVector f8 = FloatVector.fromArray(VECTOR_SPECIES, (float[])COEFFICIENTS, (int)14);
        FloatVector f9 = FloatVector.fromArray(VECTOR_SPECIES, (float[])COEFFICIENTS, (int)16);
        FloatVector f10 = FloatVector.fromArray(VECTOR_SPECIES, (float[])COEFFICIENTS, (int)18);
        FloatVector f11 = FloatVector.fromArray(VECTOR_SPECIES, (float[])COEFFICIENTS, (int)20);
        FloatVector f12 = FloatVector.fromArray(VECTOR_SPECIES, (float[])COEFFICIENTS, (int)22);
        for (int x = 0; x < 2048; ++x) {
            FloatVector accumulator = FloatVector.zero(VECTOR_SPECIES);
            accumulator = f1.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)x), (Vector)accumulator);
            accumulator = f2.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 2)), (Vector)accumulator);
            accumulator = f3.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 4)), (Vector)accumulator);
            accumulator = f4.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 6)), (Vector)accumulator);
            accumulator = f5.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 8)), (Vector)accumulator);
            accumulator = f6.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 10)), (Vector)accumulator);
            accumulator = f7.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 12)), (Vector)accumulator);
            accumulator = f8.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 14)), (Vector)accumulator);
            accumulator = f9.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 16)), (Vector)accumulator);
            accumulator = f10.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 18)), (Vector)accumulator);
            accumulator = f11.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 20)), (Vector)accumulator);
            accumulator = f12.fma((Vector)FloatVector.fromArray(VECTOR_SPECIES, (float[])this.mQBuffer, (int)(x + 22)), (Vector)accumulator);
            if (x % 2 == 0) {
                samples[2 * x] = this.mIBuffer[x];
                samples[2 * x + 1] = accumulator.reduceLanes(VectorOperators.ADD);
                continue;
            }
            samples[2 * x] = -this.mIBuffer[x];
            samples[2 * x + 1] = -accumulator.reduceLanes(VectorOperators.ADD);
        }
        System.arraycopy(this.mIBuffer, 2048, this.mIBuffer, 0, 11);
        System.arraycopy(this.mQBuffer, 2048, this.mQBuffer, 0, 23);
        return new InterleavedComplexSamples(samples, timestamp);
    }
}

