/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer;

import io.github.dsheirer.buffer.AbstractNativeBufferFactory;
import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.buffer.SignedByteNativeBuffer;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

public class SignedByteNativeBufferFactory
extends AbstractNativeBufferFactory {
    private static final long DC_PROCESSING_INTERVAL = TimeUnit.SECONDS.toMillis(60L);
    private static final int DC_CALCULATIONS_PER_INTERVAL = 5;
    private static final float TARGET_DC_OFFSET_REMAINING = 2.0E-4f;
    private int mDcCalculationsRemaining = 5;
    private long mLastDcCalculationTimestamp = 0L;
    private static final float DC_FILTER_GAIN = 0.05f;
    private float mIAverageDc = 0.0f;
    private float mQAverageDc = 0.0f;

    @Override
    public INativeBuffer getBuffer(ByteBuffer samples, long timestamp) {
        byte[] copy = new byte[samples.capacity()];
        samples.get(copy);
        if (this.shouldCalculateDc()) {
            this.calculateDc(copy);
        }
        return new SignedByteNativeBuffer(copy, timestamp, this.mIAverageDc, this.mQAverageDc, this.getSamplesPerMillisecond());
    }

    private boolean shouldCalculateDc() {
        if (System.currentTimeMillis() > this.mLastDcCalculationTimestamp + DC_PROCESSING_INTERVAL) {
            if (this.mDcCalculationsRemaining > 0) {
                return true;
            }
            this.mDcCalculationsRemaining = 5;
            this.mLastDcCalculationTimestamp = System.currentTimeMillis();
        }
        return false;
    }

    private void calculateDc(byte[] samples) {
        float iDcAccumulator = 0.0f;
        float qDcAccumulator = 0.0f;
        for (int x = 0; x < samples.length; x += 2) {
            iDcAccumulator += (float)samples[x];
            qDcAccumulator += (float)samples[x + 1];
        }
        iDcAccumulator /= (float)(samples.length / 2);
        iDcAccumulator /= 128.0f;
        this.mIAverageDc += (iDcAccumulator -= this.mIAverageDc) * 0.05f;
        qDcAccumulator /= (float)(samples.length / 2);
        qDcAccumulator /= 128.0f;
        this.mQAverageDc += (qDcAccumulator -= this.mQAverageDc) * 0.05f;
        if (Math.abs(iDcAccumulator) < 2.0E-4f && Math.abs(qDcAccumulator) < 2.0E-4f) {
            --this.mDcCalculationsRemaining;
        }
    }
}

