/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer;

import io.github.dsheirer.buffer.AbstractNativeBuffer;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.sample.complex.InterleavedComplexSamples;
import java.util.Iterator;

public class SignedByteNativeBuffer
extends AbstractNativeBuffer {
    private static final int FRAGMENT_SIZE = 2048;
    private static final float[] LOOKUP_VALUES = new float[256];
    private byte[] mSamples;
    private float mIAverageDc;
    private float mQAverageDc;

    public SignedByteNativeBuffer(byte[] samples, long timestamp, float iAverageDc, float qAverageDc, float samplesPerMillisecond) {
        super(timestamp, samplesPerMillisecond);
        if (samples.length % 2048 != 0) {
            throw new IllegalArgumentException("Samples byte[] length [" + samples.length + "] must be an even multiple of 2048");
        }
        this.mSamples = samples;
        this.mIAverageDc = iAverageDc;
        this.mQAverageDc = qAverageDc;
    }

    @Override
    public int sampleCount() {
        return this.mSamples.length / 2;
    }

    @Override
    public Iterator<ComplexSamples> iterator() {
        return new ComplexSamplesIterator();
    }

    @Override
    public Iterator<InterleavedComplexSamples> iteratorInterleaved() {
        return new InterleavedComplexSamplesIterator();
    }

    static {
        for (int x = 0; x < 256; ++x) {
            SignedByteNativeBuffer.LOOKUP_VALUES[x] = (float)((byte)x) / 128.0f;
        }
    }

    private class ComplexSamplesIterator
    implements Iterator<ComplexSamples> {
        private int mSamplesPointer = 0;

        private ComplexSamplesIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.mSamplesPointer < SignedByteNativeBuffer.this.mSamples.length;
        }

        @Override
        public ComplexSamples next() {
            long timestamp = SignedByteNativeBuffer.this.getFragmentTimestamp(this.mSamplesPointer);
            float[] i = new float[2048];
            float[] q = new float[2048];
            int samplesOffset = this.mSamplesPointer;
            for (int pointer = 0; pointer < i.length; ++pointer) {
                i[pointer] = LOOKUP_VALUES[0xFF & SignedByteNativeBuffer.this.mSamples[samplesOffset++]] - SignedByteNativeBuffer.this.mIAverageDc;
                q[pointer] = LOOKUP_VALUES[0xFF & SignedByteNativeBuffer.this.mSamples[samplesOffset++]] - SignedByteNativeBuffer.this.mQAverageDc;
            }
            this.mSamplesPointer = samplesOffset;
            return new ComplexSamples(i, q, timestamp);
        }
    }

    private class InterleavedComplexSamplesIterator
    implements Iterator<InterleavedComplexSamples> {
        private int mSamplesPointer = 0;

        private InterleavedComplexSamplesIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.mSamplesPointer < SignedByteNativeBuffer.this.mSamples.length;
        }

        @Override
        public InterleavedComplexSamples next() {
            long timestamp = SignedByteNativeBuffer.this.getFragmentTimestamp(this.mSamplesPointer);
            float[] converted = new float[4096];
            int samplesOffset = this.mSamplesPointer;
            for (int pointer = 0; pointer < converted.length; pointer += 2) {
                converted[pointer] = LOOKUP_VALUES[0xFF & SignedByteNativeBuffer.this.mSamples[samplesOffset++]] - SignedByteNativeBuffer.this.mIAverageDc;
                converted[pointer + 1] = LOOKUP_VALUES[0xFF & SignedByteNativeBuffer.this.mSamples[samplesOffset++]] - SignedByteNativeBuffer.this.mQAverageDc;
            }
            this.mSamplesPointer = samplesOffset;
            return new InterleavedComplexSamples(converted, timestamp);
        }
    }
}

