/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer;

import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import java.util.concurrent.LinkedTransferQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeSampleDelayBuffer
implements Listener<INativeBuffer> {
    private static final Logger mLog = LoggerFactory.getLogger(NativeSampleDelayBuffer.class);
    private Broadcaster<INativeBuffer> mBroadcaster = new Broadcaster();
    private LinkedTransferQueue<ActionRequest> mActionQueue = new LinkedTransferQueue();
    private INativeBuffer[] mDelayBuffer;
    private int mDelayBufferPointer = 0;
    private long mBufferDuration;

    public NativeSampleDelayBuffer(int size, long bufferDuration) {
        this.mDelayBuffer = new INativeBuffer[size];
        this.mBufferDuration = bufferDuration;
    }

    public void dispose() {
        this.clearBuffer();
        this.mBroadcaster.clear();
    }

    public void clear() {
        this.mActionQueue.offer(new ActionRequest(this));
    }

    private void clearBuffer() {
        for (int x = 0; x < this.mDelayBuffer.length; ++x) {
            this.mDelayBuffer[x] = null;
        }
        this.mDelayBufferPointer = 0;
    }

    @Override
    public synchronized void receive(INativeBuffer samples) {
        ActionRequest actionRequest = this.mActionQueue.poll();
        while (actionRequest != null) {
            switch (actionRequest.getAction()) {
                case ADD_LISTENER: {
                    this.processNewListener(actionRequest);
                    break;
                }
                case REMOVE_LISTENER: {
                    this.mBroadcaster.removeListener(actionRequest.getListener());
                    break;
                }
                case CLEAR_BUFFER: {
                    this.clearBuffer();
                }
            }
            actionRequest = this.mActionQueue.poll();
        }
        this.mBroadcaster.receive(samples);
        this.mDelayBuffer[this.mDelayBufferPointer++] = samples;
        this.mDelayBufferPointer %= this.mDelayBuffer.length;
    }

    public boolean hasListeners() {
        return this.mBroadcaster.hasListeners();
    }

    private void processNewListener(ActionRequest listenerToAdd) {
        int pointer = this.mDelayBufferPointer;
        for (int x = 0; x < this.mDelayBuffer.length; ++x) {
            INativeBuffer toEvaluate = this.mDelayBuffer[pointer];
            if (toEvaluate != null && toEvaluate.getTimestamp() + this.mBufferDuration >= listenerToAdd.getTimestamp()) {
                listenerToAdd.getListener().receive(toEvaluate);
            }
            if (++pointer < this.mDelayBuffer.length) continue;
            pointer = 0;
        }
        this.mBroadcaster.addListener(listenerToAdd.getListener());
    }

    public void addListener(Listener<INativeBuffer> listener, long timestamp) {
        this.mActionQueue.add(new ActionRequest<INativeBuffer>(this, listener, timestamp));
    }

    public void removeListener(Listener<INativeBuffer> listener) {
        this.mActionQueue.add(new ActionRequest<INativeBuffer>(this, listener));
    }

    public class ActionRequest<T extends INativeBuffer> {
        private Action mAction;
        private Listener<T> mListener;
        private long mTimestamp;

        public ActionRequest(NativeSampleDelayBuffer this$0, Listener<T> listener, long timestamp) {
            this.mAction = Action.ADD_LISTENER;
            this.mListener = listener;
            this.mTimestamp = timestamp;
        }

        public ActionRequest(NativeSampleDelayBuffer this$0, Listener<T> listener) {
            this.mAction = Action.REMOVE_LISTENER;
            this.mListener = listener;
        }

        public ActionRequest(NativeSampleDelayBuffer this$0) {
            this.mAction = Action.CLEAR_BUFFER;
        }

        public Action getAction() {
            return this.mAction;
        }

        public Listener<T> getListener() {
            return this.mListener;
        }

        public long getTimestamp() {
            return this.mTimestamp;
        }
    }

    private static enum Action {
        ADD_LISTENER,
        REMOVE_LISTENER,
        CLEAR_BUFFER;

    }
}

