/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer;

import io.github.dsheirer.buffer.AbstractNativeBuffer;
import io.github.dsheirer.sample.SampleUtils;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.sample.complex.InterleavedComplexSamples;
import java.util.Arrays;
import java.util.Iterator;

public class FloatNativeBuffer
extends AbstractNativeBuffer {
    private float[] mInterleavedComplexSamples;
    private static final int BUFFER_SIZE = 2048;

    public FloatNativeBuffer(float[] complexSamples, long timestamp, float samplesPerMillisecond) {
        super(timestamp, samplesPerMillisecond);
        this.mInterleavedComplexSamples = complexSamples;
    }

    public FloatNativeBuffer(ComplexSamples samples) {
        this(SampleUtils.interleave(samples), samples.timestamp(), 0.0f);
    }

    public FloatNativeBuffer(InterleavedComplexSamples samples) {
        this(samples.samples(), samples.timestamp(), 0.0f);
    }

    @Override
    public Iterator<ComplexSamples> iterator() {
        return new ComplexSamplesIterator();
    }

    @Override
    public Iterator<InterleavedComplexSamples> iteratorInterleaved() {
        return new InterleavedComplexSamplesIterator();
    }

    @Override
    public int sampleCount() {
        return this.mInterleavedComplexSamples.length / 2;
    }

    private class ComplexSamplesIterator
    implements Iterator<ComplexSamples> {
        private int mBufferPointer = 0;

        private ComplexSamplesIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.mBufferPointer < FloatNativeBuffer.this.mInterleavedComplexSamples.length;
        }

        @Override
        public ComplexSamples next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("No more samples");
            }
            float[] chunk = Arrays.copyOfRange(FloatNativeBuffer.this.mInterleavedComplexSamples, this.mBufferPointer, this.mBufferPointer + 4096);
            this.mBufferPointer += 4096;
            return SampleUtils.deinterleave(chunk, FloatNativeBuffer.this.getTimestamp());
        }
    }

    private class InterleavedComplexSamplesIterator
    implements Iterator<InterleavedComplexSamples> {
        private int mBufferPointer = 0;

        private InterleavedComplexSamplesIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.mBufferPointer < FloatNativeBuffer.this.mInterleavedComplexSamples.length;
        }

        @Override
        public InterleavedComplexSamples next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("No more samples");
            }
            float[] chunk = Arrays.copyOfRange(FloatNativeBuffer.this.mInterleavedComplexSamples, this.mBufferPointer, this.mBufferPointer + 4096);
            this.mBufferPointer += 4096;
            return new InterleavedComplexSamples(chunk, FloatNativeBuffer.this.getTimestamp());
        }
    }
}

