/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer;

import java.util.Arrays;

public class FloatCircularBuffer {
    private float[] mBuffer;
    private int mBufferPointer = 0;

    public FloatCircularBuffer(int size, float initialFillValue) {
        this.mBuffer = new float[size];
        Arrays.fill(this.mBuffer, initialFillValue);
    }

    public FloatCircularBuffer(int size) {
        this(size, 0.0f);
    }

    public void reset(float fillValue) {
        Arrays.fill(this.mBuffer, fillValue);
    }

    public float get(float newValue) {
        float oldestSample = this.mBuffer[this.mBufferPointer];
        this.mBuffer[this.mBufferPointer] = newValue;
        ++this.mBufferPointer;
        if (this.mBufferPointer >= this.mBuffer.length) {
            this.mBufferPointer = 0;
        }
        return oldestSample;
    }

    public float[] getAll() {
        int valuePointer = 0;
        float[] values = new float[this.mBuffer.length];
        int bufferPointer = this.mBufferPointer;
        while (valuePointer < values.length) {
            values[valuePointer++] = this.mBuffer[bufferPointer++];
            if (bufferPointer < this.mBuffer.length) continue;
            bufferPointer = 0;
        }
        return values;
    }

    public void put(float newValue) {
        this.mBuffer[this.mBufferPointer] = newValue;
        ++this.mBufferPointer;
        if (this.mBufferPointer >= this.mBuffer.length) {
            this.mBufferPointer = 0;
        }
    }

    public float max(float referenceValue) {
        float max = referenceValue;
        for (int x = 0; x < this.mBuffer.length; ++x) {
            if (!(this.mBuffer[x] > max)) continue;
            max = this.mBuffer[x];
        }
        return max;
    }

    public float min() {
        float min = 0.0f;
        for (int x = 0; x < this.mBuffer.length; ++x) {
            if (!(this.mBuffer[x] < min)) continue;
            min = this.mBuffer[x];
        }
        return min;
    }

    public float mean() {
        double accumulator = 0.0;
        for (float value : this.mBuffer) {
            accumulator += (double)value;
        }
        return (float)(accumulator / (double)this.mBuffer.length);
    }
}

