/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.buffer;

import io.github.dsheirer.sample.complex.Complex;

public class ComplexTappedCircularBuffer {
    private Complex[] mBuffer;
    private int mBufferPointer = 0;

    public ComplexTappedCircularBuffer(int length) {
        this.mBuffer = new Complex[length];
        for (int x = 0; x < length; ++x) {
            this.mBuffer[x] = new Complex(0.0f, 0.0f);
        }
    }

    public void add(Complex sample) {
        this.mBuffer[this.mBufferPointer++] = sample;
        if (this.mBufferPointer >= this.mBuffer.length) {
            this.mBufferPointer = 0;
        }
    }

    public Complex get(int index) {
        int pointer = this.mBuffer.length - 1 + this.mBufferPointer - index;
        if (pointer >= this.mBuffer.length) {
            pointer -= this.mBuffer.length;
        }
        return this.mBuffer[pointer];
    }
}

